/*
 *  Copyright 2001, 2002 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _TABCODEGEN_H
#define _TABCODEGEN_H

#include <iostream>
#include "fsmcodegen.h"

/* Forwards. */
struct ParseData;
struct NameInst;
struct RedTransAp;
struct RedStateAp;

/*
 * TabCodeGen
 */
class TabCodeGen : public FsmCodeGen
{
public:
	TabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );
	virtual ~TabCodeGen() { }

protected:
	std::ostream &ACTION_SWITCH();
	std::ostream &INDEX_TYPE();
	std::ostream &FIRST_FINAL_STATE();
	std::ostream &ERROR_STATE();
	std::ostream &KEYS();
	std::ostream &INDICIES();
	std::ostream &STATES();
	std::ostream &TRANSITIONS();
	std::ostream &BSEARCH();
	std::ostream &RANGE_BSEARCH();
	std::ostream &LOCATE_TRANS();
	std::ostream &STACK( int size );
	std::ostream &GOTO( NameInst *name, bool inFinish );
	std::ostream &GOTOE( char *stateExpr, bool inFinish );
	std::ostream &CURS( bool inFinish );
	std::ostream &TARGS( bool inFinish, int targState );
	std::ostream &GET_STATE( NameInst *name, bool inFinish );
	std::ostream &NEXT( NameInst *name, bool inFinish );
	std::ostream &NEXTE( char *stateExpr, bool inFinish );

	int makeStateSpec( RedStateAp *state );
	int getStateLen( int stateSpec );
	void calcStatePositions();

	virtual std::ostream &STATE_OUT_ACTION( RedStateAp *state );
	virtual std::ostream &TRANS_ACTION( RedTransAp *trans );
};

/*
 * CTabCodeGen
 */
class CTabCodeGen : public TabCodeGen
{
public:
	CTabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( char *stateExpr, int targState, bool inFinish );

	/* Write out the C lang header. */
	virtual void writeOutHeader();

	/* Write out the C lang code. */
	virtual void writeOutCode();

};

/*
 * CCTabCodeGen
 */
class CCTabCodeGen : public TabCodeGen
{
public:
	CCTabCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( char *stateExpr, int targState, bool inFinish );

	/* Write out the C++ lang header. */
	virtual void writeOutHeader();

	/* Write out the C++ lang code. */
	virtual void writeOutCode();
};


#endif /* _TABCODEGEN_H */
