/*
 * Parse command line arguments.
 */

#include <stdio.h>
#include <string.h>

#define BUFLEN 1024

%% params
	# A buffer to collect argurments
	struct {
		char buffer[BUFLEN+1];
		int buflen;
	};

	# Init the buffer.
	init {
		fsm->buflen = 0;
	}

	# Append to the buffer.
	action append {
		if ( fsm->buflen < BUFLEN )
			fsm->buffer[fsm->buflen++] = fc;
	}

	# Terminate a buffer.
	action term {
		if ( fsm->buflen < BUFLEN )
			fsm->buffer[fsm->buflen++] = 0;
	}

	# Clear out the buffer
	action clear { fsm->buflen = 0; }

	action help { printf("help\n"); }
	action version { printf("version\n"); }
	action output { printf("output: \"%s\"\n", fsm->buffer); }
	action spec { printf("spec: \"%s\"\n", fsm->buffer); }
	action machine { printf("machine: \"%s\"\n", fsm->buffer); }

	# Helpers that collect strings
	string = [^\0]+ >clear $append %term;

	# Different arguments.
	help = ( '-h' | '-H' | '-?' | '--help' ) 0 @help;
	version = ( '-v' | '--version' ) 0 @version;
	output = '-o' 0? string 0 @output;
	spec = '-S' 0? string 0 @spec;
	machine = '-M' 0? string 0 @machine;

	main := ( 
		help | 
		version | 
		output |
        spec |
		machine
	)*;
%%

#define BUFSIZE 2048

int main( int argc, char **argv )
{
	int a;
	struct params params;

	params_init( &params );
	for ( a = 1; a < argc; a++ )
		params_execute( &params, argv[a], strlen(argv[a])+1 );
	if ( params_finish( &params ) != 1 )
		fprintf( stderr, "params: error processing arguments\n" );

	return 0;
}
