/*
 *  Copyright 2001-2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FGOTOCODEGEN_H
#define _FGOTOCODEGEN_H

#include <iostream>
#include "gotocodegen.h"

/* Forwards. */
struct ParseData;


/*
 * class FGotoCodeGen
 */
class FGotoCodeGen : public GotoCodeGen
{
public:
	std::ostream &EXEC_ACTIONS();
	std::ostream &FINISH_CASES();
};

/*
 * class CFGotoCodeGen
 */
class CFGotoCodeGen : public FGotoCodeGen, public CCodeGen
{
public:
	CFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * class CppFGotoCodeGen
 */
class CppFGotoCodeGen : public FGotoCodeGen, public CppCodeGen
{
public:
	CppFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * class ObjCFGotoCodeGen
 */
class ObjCFGotoCodeGen : public FGotoCodeGen, public ObjCCodeGen
{
public:
	ObjCFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

#endif /* _FGOTOCODEGEN_H */
