/*
 *  Copyright 2004, 2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FLATCODEGEN_H
#define _FLATCODEGEN_H

#include <iostream>
#include "fsmcodegen.h"

/* Forwards. */
struct ParseData;
struct NameInst;
struct RedTransAp;
struct RedStateAp;

/*
 * FlatCodeGen
 */
class FlatCodeGen : virtual public FsmCodeGen
{
public:
	virtual ~FlatCodeGen() { }

protected:
	std::ostream &ACTION_SWITCH();
	std::ostream &FIRST_FINAL_STATE();
	std::ostream &ERROR_STATE();
	std::ostream &KEYS();
	std::ostream &INDICIES();
	std::ostream &FLAT_INDEX_OFFSET();
	std::ostream &KEY_SPANS();
	std::ostream &EOF_ACTIONS();
	std::ostream &TRANS_TARGS();
	std::ostream &TRANS_ACTIONS();
	std::ostream &LOCATE_TRANS();
	std::ostream &GOTO( NameInst *name, bool inFinish );
	std::ostream &GOTOE( InlineItem *ilItem, bool inFinish );
	std::ostream &CURS( bool inFinish );
	std::ostream &TARGS( bool inFinish, int targState );
	std::ostream &GET_ENTRY( NameInst *name, bool inFinish );
	std::ostream &NEXT( NameInst *name, bool inFinish );
	std::ostream &NEXTE( InlineItem *ilItem, bool inFinish );
	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CONTEXT( int contextId );
	std::ostream &STATE_DATA();

	virtual std::ostream &STATE_OUT_ACTION( RedStateAp *state );
	virtual std::ostream &TRANS_ACTION( RedTransAp *trans );
};

/*
 * CFlatCodeGen
 */
class CFlatCodeGen : public FlatCodeGen, public CCodeGen
{
public:
	CFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * CppFlatCodeGen
 */
class CppFlatCodeGen : public FlatCodeGen, public CppCodeGen
{
public:
	CppFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * ObjCFlatCodeGen
 */
class ObjCFlatCodeGen : public FlatCodeGen, public ObjCCodeGen
{
public:
	ObjCFlatCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


#endif /* _FLATCODEGEN_H */
