/*
 *  Copyright 2001-2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _GOTOCODEGEN_H
#define _GOTOCODEGEN_H

#include <iostream>
#include "fsmcodegen.h"

/* Forwards. */
struct ParseData;
struct NameInst;
struct RedTransAp;
struct RedStateAp;

/*
 * Goto driven fsm.
 */
class GotoCodeGen : virtual public FsmCodeGen
{
public:
	std::ostream &FIRST_FINAL_STATE();
	std::ostream &ERROR_STATE();
	std::ostream &ACTION_SWITCH();
	std::ostream &STATE_GOTOS();
	std::ostream &TRANSITIONS();
	std::ostream &EXEC_FUNCS();
	std::ostream &FINISH_CASES();
	std::ostream &GOTO( NameInst *name, bool inFinish );
	std::ostream &GOTOE( InlineItem *ilItem, bool inFinish );
	std::ostream &CURS( bool inFinish );
	std::ostream &TARGS( bool inFinish, int targState );
	std::ostream &GET_ENTRY( NameInst *name, bool inFinish );
	std::ostream &NEXT( NameInst *name, bool inFinish );
	std::ostream &NEXTE( InlineItem *ilItem, bool inFinish );
	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CONTEXT( int contextId );

	virtual std::ostream &TRANS_GOTO( RedTransAp *trans, int level );

	void emitSingleSwitch( RedStateAp *state );
	void emitRangeBSearch( RedStateAp *state, int level, int low, int high );

	/* Called from STATE_GOTOS just before writing the gotos */
	virtual std::ostream &GOTO_HEADER( RedStateAp *state );

	/* Set up labelNeeded flag for each state. */
	void setLabelsNeeded();
};

/*
 * class CGotoCodeGen
 */
class CGotoCodeGen : public GotoCodeGen, public CCodeGen
{
public:
	CGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

/*
 * class CppGotoCodeGen
 */
class CppGotoCodeGen : public GotoCodeGen, public CppCodeGen
{
public:
	CppGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


/*
 * class ObjCGotoCodeGen
 */
class ObjCGotoCodeGen : public GotoCodeGen, public ObjCCodeGen
{
public:
	ObjCGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


#endif /* _GOTOCODEGEN_H */
