/*
 *  Copyright 2001-2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _IPGCODEGEN_H
#define _IPGCODEGEN_H

#include <iostream>
#include "gotocodegen.h"

/* Forwards. */
struct ParseData;

/*
 * class FGotoCodeGen
 */
class IpGotoCodeGen : public GotoCodeGen
{
public:
	std::ostream &EXIT_STATES();
	std::ostream &TRANS_GOTO( RedTransAp *trans, int level );
	std::ostream &FINISH_CASES();
	std::ostream &CURS( bool inFinish );
	std::ostream &TARGS( bool inFinish, int targState );
	std::ostream &GOTO( NameInst *name, bool inFinish );
	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );
	std::ostream &GOTOE( InlineItem *ilItem, bool inFinish );
	std::ostream &NEXT( NameInst *name, bool inFinish );
	std::ostream &NEXTE( InlineItem *ilItem, bool inFinish );


protected:
	/* Called from GotoCodeGen::STATE_GOTOS just before writing the gotos for
	 * each state. */
	std::ostream &GOTO_HEADER( RedStateAp *state );

	/* Set up labelNeeded flag for each state. */
	void setLabelsNeeded( InlineList *inlineList );
	void setLabelsNeeded();
};


/*
 * class CIpGotoCodeGen
 */
class CIpGotoCodeGen : public IpGotoCodeGen, public CCodeGen
{
public:
	CIpGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


/*
 * class CppIpGotoCodeGen
 */
class CppIpGotoCodeGen : public IpGotoCodeGen, public CppCodeGen
{
public:
	CppIpGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};


/*
 * class ObjCIpGotoCodeGen
 */
class ObjCIpGotoCodeGen : public IpGotoCodeGen, public ObjCCodeGen
{
public:
	ObjCIpGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	virtual void writeOutCode();
};

#endif /* _IPGCODEGEN_H */
