/*
 *  Copyright 2003 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _PTREETYPES_H
#define _PTREETYPES_H

/* Leaf type. */
struct Literal;

/* Tree nodes. */

struct Term;
struct FactorWithAug;
struct FactorWithRep;
struct FactorWithNeg;
struct Factor;
struct Expression;
struct Join;
struct LongestMatchPart;
struct LongestMatchList;

/* Type of augmentation. Describes locations in the machine. */
enum AugType
{
	/* Transition actions/priorities. */
	at_start,
	at_all,
	at_finish,
	at_leave,

	/* Global error actions. */
	at_start_gbl_error,
	at_all_gbl_error,
	at_finish_gbl_error,
	at_leave_gbl_error,
	at_start_finish_gbl_error,
	at_finish_leave_gbl_error,

	/* Local error actions. */
	at_start_local_error,
	at_all_local_error,
	at_finish_local_error,
	at_leave_local_error,
	at_start_finish_local_error,
	at_finish_leave_local_error,
	
	/* Context Embedding. */
	at_start_context,
	at_all_context,
	at_finish_context,
	at_leave_context,
	at_start_finish_context,
	at_finish_leave_context,

	/* EOF Action embedding. */
	at_start_eof,
	at_all_eof,
	at_finish_eof,
	at_leave_eof,
	at_start_finish_eof,
	at_finish_leave_eof
};

struct Action;
struct PriorDesc;
struct RegExpr;
struct ReItem;
struct ReOrBlock;
struct ReOrItem;
struct ExplicitMachine;
struct InlineItem;
struct InlineList;

#endif /* _PTREETYPES_H */
