#include <stdio.h>

void alph(const char *type)
{
	printf("%s\n", type);
}

struct builtin
{
	int curs;
};

%% builtin {
	alphtype unsigned int;
	main := (
		any    @{alph("any");} |
		ascii  @{alph("ascii");} |
		extend @{alph("extend");} |
		alpha  @{alph("alpha");} |
		digit  @{alph("digit");} |
		alnum  @{alph("alnum");} |
		lower  @{alph("lower");} |
		upper  @{alph("upper");} |
		cntrl  @{alph("cntrl");} |
		graph  @{alph("graph");} |
		print  @{alph("print");} |
		punct  @{alph("punct");} |
		space  @{alph("space");} |
		xdigit @{alph("xdigit");}
	)*;
}

#include <stdio.h>
#define BUFSIZE 2048

struct builtin fsm;
char buf[BUFSIZE];
unsigned int i;

int main()
{
	builtin_init( &fsm );
	while ( 1 ) {
		int conv = scanf( "%ui\n", &i );
		if ( conv != 1 )
			break;
		builtin_execute( &fsm, &i, 1 );
	}
	if ( builtin_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

