/*
 * Test error actions.
 */

#include <iostream>
#include <stdio.h>

using namespace std;

struct ErrAct 
{
	int curs;
	%% interface;
};

%% ErrAct 
{
	action expect_digit_plus_minus { printf(" DIGIT PLUS MINUS\n"); } 
	action expect_digit { printf(" DIGIT\n"); } 
	action expect_digit_decimal { printf(" DIGIT DECIMAL\n"); }

	float = (
		( 
			[\-+] >!expect_digit_plus_minus %!expect_digit |
			""
		)
		( [0-9] [0-9]* $!expect_digit_decimal )
		( '.' [0-9]+ $!expect_digit )? 
	);

	main := float '\n';
}

#define BUFSIZE 1024

int main()
{
	char buf[BUFSIZE];

	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		ErrAct errAct;

		errAct.init();
		errAct.execute( buf, strlen(buf) );
		if ( errAct.finish() > 0 )
			cout << "ACCEPT" << endl;
		else
			cout << "FAIL" << endl;
	}
	return 0;
}
