#include <stdio.h>
#include <objc/Object.h>

#define IDENT_BUFLEN 256

@interface ErrAct : Object
{
@public
	int curs;
};

%% interface;

@end

@implementation ErrAct

%% {
	# The data that is to go into the fsm structure.
	action hello_fails { printf("hello fails\n");}

	newline = ( any | '\n' @{printf("newline\n");} )*;
	hello = 'hello\n'* $^hello_fails >@/hello_fails;
	main := newline | hello;
}

@end

#include <stdio.h>
#define BUFSIZE 2048

ErrAct *fsm;
char buf[BUFSIZE];

int main()
{
	fsm = [[ErrAct alloc] init];
	
	[fsm initFsm];
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		[fsm executeWithData:buf len:len];
		if ( len != BUFSIZE )
			break;
	}
	if ( [fsm finish] > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");

	return 0;
}

