/*
 *  Copyright 2001-2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _RLCODEGEN_H
#define _RLCODEGEN_H

#include <stdio.h>
#include <iostream>
#include <fstream>
#include "avltree.h"
#include "vector.h"
#include "config.h"

#define PROGNAME "rlcodegen"


/* Target language. */
enum OutputFormat
{
	OutCCode,
	OutDCode,
	OutGraphvizDot
};

/* Target output style. */
enum CodeStyleEnum
{
	GenTables,
	GenFTables,
	GenFlat,
	GenFFlat,
	GenGoto,
	GenFGoto,
	GenIpGoto
};

/* Filter on the output stream that keeps track of the number of lines
 * output. */
class output_filter : public std::filebuf
{
public:
	output_filter() : line(1) { }

	virtual int sync();
	virtual std::streamsize xsputn(const char* s, std::streamsize n);

	int line;
};
	
extern OutputFormat outputFormat;
extern CodeStyleEnum codeStyle;

extern FILE *yyin;

/* IO filenames and stream. */
extern char *outputFile;
extern std::ostream *outStream;
extern output_filter *outFilter;

/* Options. */
extern bool graphvizDone;

void yyerror( char *error );
int yyparse();

extern int gblErrorCount;
extern char machineMain[];

/* 
 * Error reporting. 
 */

struct BISON_YYLTYPE;

#ifndef INPUT_LOC
#define INPUT_LOC
/* Location in an input file. */
struct InputLoc
{
	InputLoc( ) 
		: line(0), col(0) { }
	InputLoc( int line, int col ) 
		: line(line), col(col) { }
	InputLoc( const BISON_YYLTYPE &loc );

	int line;
	int col;
};
#endif /* INPUT_LOC */

std::ostream &error();
std::ostream &error( const BISON_YYLTYPE &loc ); 
std::ostream &error( const InputLoc &loc ); 
std::ostream &error( int first_line, int first_column );
std::ostream &warning( ); 
std::ostream &warning( const InputLoc &loc ); 
std::ostream &warning( int first_line, int first_column );
std::ostream &xml_error( const InputLoc &loc );
std::ostream &xml_error( const BISON_YYLTYPE &loc ); 

void openOutput( char *inputFile );

/* Size of the include stack. */
#define INCLUDE_STACK_SIZE 32

#endif /* _RLCODEGEN_H */
