/*
 *  Copyright 2005 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _XMLPARSE_H
#define _XMLPARSE_H

#include "vector.h"
#include "buffer.h"

struct XMLTag
{
    char *name;
    int id;
};

extern Buffer xmlData;

struct Attribute
{
	Attribute( char *key, char *value )
		: key(key), value(value) { }

	char *key;
	char *value;
};

struct AttrList 
	: public Vector<Attribute>
{
	Attribute *find( char *key )
	{
		for ( Iter a = first(); a.lte(); a++ ) {
			if ( strcmp( a->key, key ) == 0 )
				return a;
		}
		return 0;
	}
};

struct InlineItem;
struct InlineList;

struct LmSwitchVect;
struct LmSwitchAction;

#include "xmlpdefs.h"

/* These come from the scanner and point back into the parser. We will borrow
 * them for error reporting. */
extern YYSTYPE *yylval;
extern YYLTYPE *yylloc;

int yylex( YYSTYPE *, YYLTYPE *);
void scannerInit();

#endif /* _RLCODEGEN_H */
