#include <stdio.h>

struct min
{
	int cs;
};

%%{
	machine min;
	variable curstate fsm->cs;

	action a_or_b { printf("a or b\n"); }

	main := (
		( 'a' . [ab]* @a_or_b ) |
		( 'b' . [ab]* @a_or_b ) 
	) . '\n';
}%%

%% write data;

void min_init( struct min *fsm )
{
	%% write init;
}

void min_execute( struct min *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;
}

int min_finish( struct min *fsm )
{
	%% write eof;

	if ( fsm->cs == min_error )
		return -1;
	if ( fsm->cs >= min_first_final )
		return 1;
	return 0;
}


#include <stdio.h>
#define BUFSIZE 2048

struct min fsm;
char buf[BUFSIZE];

int main()
{
	min_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		min_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( min_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

