/*
 * Convert an string to an integer.
 */

module atoi3;

import std.c.stdio;
import std.string;

class AtoI
{
	bit neg;
	int val;
	int cs;

	%%{
		machine AtoI;
	
		action begin {
			neg = 0;
			val = 0;
		}

		action see_neg {
			neg = 1;
		}

		action add_digit { 
			val = val * 10 + (fc - '0');
		}

		action finish {
			if ( neg )
				val = -1 * val;
		}

		atoi = (
			('-'@see_neg | '+')? (digit @add_digit)+
		) >begin %finish;

		main := atoi '\n';
	}%%

	%% write data noprefix;

	void init( )
	{
		%% write init;
	}

	void execute( char* data, int len )
	{
		char *p = data;
		char *pe = data + len;

		%% write exec;
	}

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( )
	{
		%% write eof;

		if ( cs == error )
			return -1;
		if ( cs >= first_final )
			return 1;
		return 0;
	}
}

static const int BUFSIZE = 1024;

int main()
{
	char[BUFSIZE] buf;

	while ( fgets( buf, buf.length, stdin ) != null )
	{
		AtoI atoi = new AtoI();

		atoi.init();
		atoi.execute( buf.ptr, strlen(buf) );
		if ( atoi.finish() > 0 )
			printf("%i\n", atoi.val);
		else
			printf("FAIL\n");
	}
	return 0;
}
