#include <stdio.h>
#define IDENT_BUFLEN 256

struct erract
{
	int cs;
};

%%{
	machine erract;
	variable curstate fsm->cs;

	# The data that is to go into the fsm structure.
	action hello_fails { printf("hello fails\n");}

	newline = ( any | '\n' @{printf("newline\n");} )*;
	hello = 'hello\n'* $^hello_fails @/hello_fails;
	main := newline | hello;
}%%

%% write data;

void erract_init( struct erract *fsm )
{
	%% write init;
}

void erract_execute( struct erract *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;
	%% write exec;
}

int erract_finish( struct erract *fsm )
{
	%% write eof;

	if ( fsm->cs == erract_error )
		return -1;
	else if ( fsm->cs >= erract_first_final )
		return 1;
	return 0;
}

#include <stdio.h>
#define BUFSIZE 2048

struct erract fsm;
char buf[BUFSIZE];

int main()
{
	erract_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		erract_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( erract_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

