#include <stdio.h>

struct range
{
	int cs;
};

%%{
	machine range;
	variable curstate fsm->cs;

	main := ( 'a' .. 'c' | 'c' .. 'e' | 'm' .. 'n' | 'a' .. 'z' ) '\n';
}%%

%% write data;

void range_init( struct range *fsm )
{
	%% write init;
}

void range_execute( struct range *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;
}

int range_finish( struct range *fsm )
{
	%% write eof;

	if ( fsm->cs == range_error )
		return -1;
	if ( fsm->cs >= range_first_final )
		return 1;
	return 0;
}

#include <stdio.h>
#define BUFSIZE 2048

struct range fsm;
char buf[BUFSIZE];

int main()
{
	range_init( &fsm );
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		range_execute( &fsm, buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( range_finish( &fsm ) > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

