/* Test repeptition operators. */

#include <iostream>
#include <stdlib.h>
#include <stdio.h>

using namespace std;

struct Rep
{
	int cs;

	int init( );
	int execute( const char *data, int len );
	int finish( );
};

%%{
	machine Rep;

	action begin { cout << "begin" << endl; }
	action in { cout << "in" << endl; }
	action end { cout << "end" << endl; }

	a = 'a' >begin @in %end;
	b = 'b' >begin @in %end;
	c = 'c' >begin @in %end;
	d = 'd' >begin @in %end;

	main := 
		( a {5} '\n' )* '-\n'
		( b {,5} '\n' )* '-\n'
		( c {5,} '\n' )* '-\n'
		( d {2,5} '\n' )*;
}%%

%% write data;

int Rep::init( )
{
	%% write init;
	return 1;
}

int Rep::execute( const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;

	if ( cs == Rep_error )
		return -1;
	if ( cs >= Rep_first_final )
		return 1;
	return 0;
}

int Rep::finish( )
{
	%% write eof;
	if ( cs == Rep_error )
		return -1;
	if ( cs >= Rep_first_final )
		return 1;
	return 0;
}


#define BUFSIZE 1024


int main()
{
	Rep rep;
	char buf[BUFSIZE];

	rep.init();
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		rep.execute( buf, len );
		if ( len != BUFSIZE )
			break;
	}
	if ( rep.finish() > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	return 0;
}

