/*
  rakarrack - a guitar effects software

 process.C  -  mainloop functions
  Copyright (C) 2008 Daniel Vidal & Josep Andreu
  Author: Daniel Vidal & Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <Fl/Fl_Preferences.H>
#include "global.h"

int Pexitprogram, preset;
int commandline;
int exitwithhelp, gui, nojack;
int PERIOD;
unsigned int SAMPLE_RATE;
float val_sum;
int note_active[POLY];
int rnote[POLY];
int gate[POLY];
int reconota;
float r__ratio;
Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

Pixmap p, mask;
XWMHints *hints;

RKR::RKR ()
{

  char temp[128];

  nojack = 0;
  estuvo = 0;
  memset(Mcontrol, 0, sizeof(Mcontrol));
  Mvalue = 0;

  sprintf (temp, "rakarrack");
  jackclient = jack_client_open (temp, options, &status, NULL);

  if (jackclient == NULL)
    {
      fprintf (stderr, "Cannot make a jack client, is jackd running?\n");
      nojack = 1;
      exitwithhelp = 1;
      return;

    }

  strcpy (jackcliname, jack_get_client_name (jackclient));
  SAMPLE_RATE = jack_get_sample_rate (jackclient);
  PERIOD = jack_get_buffer_size (jackclient);



  Master_Volume = 0.50;
  Input_Gain = 0.50;
  Cabinet_Preset = 0;

  rakarrack.get (PrefNom("Harmonizer Quality"), HarQual, 4);
  rakarrack.get (PrefNom("Auto Connect Jack"), aconnect_JA, 1);
  rakarrack.get (PrefNom("Auto Connect Num"), cuan_jack, 2);

  int i;
  bzero (temp, sizeof (temp));
  char j_names[128];

  static const char *jack_names[] =
    { "system:playback_1", "system:playback_2" };

  for (i = 0; i < cuan_jack; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "Jack Port %d", i + 1);
      if (i < 2)
	strcpy (j_names, jack_names[i]);
      else
	strcpy (j_names, "");
      rakarrack.get (temp, PrefNom(jack_po[i].name), j_names, 128);
    }



  efxoutl = (float *) malloc (sizeof (float) * PERIOD);
  efxoutr = (float *) malloc (sizeof (float) * PERIOD);

  smpl = (float *) malloc (sizeof (float) * PERIOD);
  smpr = (float *) malloc (sizeof (float) * PERIOD);

  denormal = (float *) malloc (sizeof (float) * PERIOD);

  for (int i = 0; i < PERIOD; i++)
    denormal[i] = (RND - 0.5) * 1e-16;


  efx_Chorus = new Chorus (efxoutl, efxoutr);
  efx_Flanger = new Chorus (efxoutl, efxoutr);
  efx_Rev = new Reverb (efxoutl, efxoutr);
  efx_Echo = new Echo (efxoutl, efxoutr);
  efx_Phaser = new Phaser (efxoutl, efxoutr);
  efx_Distorsion = new Distorsion (efxoutl, efxoutr);
  efx_Overdrive = new Distorsion (efxoutl, efxoutr);
  efx_EQ2 = new EQ (efxoutl, efxoutr);
  efx_EQ1 = new EQ (efxoutl, efxoutr);
  efx_Compressor = new Compressor (efxoutl, efxoutr);
  efx_WhaWha = new DynamicFilter (efxoutl, efxoutr);
  efx_Alienwah = new Alienwah (efxoutl, efxoutr);
  efx_Cabinet = new EQ (efxoutl, efxoutr);
  efx_Pan = new Pan (efxoutl, efxoutr);
  efx_Har = new Harmonizer (efxoutl, efxoutr, (long) HarQual);
  efx_MusDelay = new MusicDelay (efxoutl, efxoutr);
  efx_Gate = new Gate (efxoutl, efxoutr);
  efx_Tuner = new Tuner (efxoutl, efxoutr);
  efx_MIDIConverter = new MIDIConverter (efxoutl, efxoutr);
  RecNote = new Recognize (efxoutl, efxoutr);
  RC = new RecChord ();


  Data_Version = (char *) malloc (sizeof (char) * 16);
  memset (Data_Version, 0, sizeof (char) * 16);
  Preset_Name = (char *) malloc (sizeof (char) * 64);
  memset (Preset_Name, 0, sizeof (char) * 64);
  Author = (char *) malloc (sizeof (char) * 64);
  memset (Author, 0, sizeof (char) * 64);
  Bank_Saved = (char *) malloc (sizeof (char) * 128);
  memset (Bank_Saved, 0, sizeof (char) * 128);
  UserRealName = (char *) malloc (sizeof (char) * 128);
  memset (UserRealName, 0, sizeof (char) * 128);

// Names

  {
    static const char *los_names[] =
      { "EQ", "Compressor", "Distorsion", "Overdrive", "Echo", "Chorus",
      "Phaser", "Flanger", "Reverb",
      "Parametric EQ", "WahWah", "AlienWah", "Cabinet", "Pan", "Harmonizer",
      "MusicalDelay", "NoiseGate"
    };
    for (int i = 0; i < 17; i++)
      strcpy (efx_names[i].Nom, los_names[i]);
  }



// Init Preset

  New ();

// Init Bank

  New_Bank ();

  init_rkr ();


}



RKR::~RKR ()
{

  if (exitwithhelp == 0)
    snd_seq_close (midi_in);

};




void
RKR::init_rkr ()
{

  Tuner_Bypass = 0;
  MIDIConverter_Bypass = 0;

  for (int i = 0; i <= 45; i += 5)
    {
      efx_EQ1->changepar (i + 10, 7);
      efx_EQ1->changepar (i + 14, 0);
    }

  efx_EQ1->changepar (0 + 11, 8);
  efx_EQ1->changepar (5 + 11, 22);
  efx_EQ1->changepar (10 + 11, 35);
  efx_EQ1->changepar (15 + 11, 48);
  efx_EQ1->changepar (20 + 11, 61);
  efx_EQ1->changepar (25 + 11, 74);
  efx_EQ1->changepar (30 + 11, 87);
  efx_EQ1->changepar (35 + 11, 100);
  efx_EQ1->changepar (40 + 11, 113);
  efx_EQ1->changepar (45 + 11, 126);

  for (int i = 0; i <= 10; i += 5)
    {
      efx_EQ2->changepar (i + 10, 7);
      efx_EQ2->changepar (i + 13, 64);
      efx_EQ2->changepar (i + 14, 0);

    }

  old_i_sum = 0.0;
  old_v_sum = 0.0;
  val_i_sum = 0.0;
  val_v_sum = 0.0;

  note_old = 0;
  nfreq_old = 0;
  afreq_old = 0;
  cents_old = 0;

  midivol = 0;
  preset = 1000;
  MidiCh = 0;


  help_displayed = 0;
  modified = 0;


// Load Preset Bank File

  char temp[128];
  bzero (temp, sizeof (temp));
  sprintf (temp, "%s/Default.rkrb", DATADIR);
  rakarrack.get (PrefNom("Bank Filename"), BankFilename, temp, 127);

  if (commandline == 0)
    loadbank (BankFilename);


  RC->cleanup ();
  reconota = -1;




}


void
RKR::ConnectMIDI ()
{


  Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

// Get config settings and init settings
// Get MIDI IN Setting

  rakarrack.get (PrefNom("Auto Connect MIDI IN"), aconnect_MI, 0);
  rakarrack.get (PrefNom("MIDI IN Device"), MID, "", 40);
  if (aconnect_MI)
    Conecta ();



}

int
RKR::Cabinet_setpreset (unsigned char npreset)
{

  const int PRESET_SIZE = 81;
  const int NUM_PRESETS = 13;
  unsigned char presets[NUM_PRESETS][PRESET_SIZE] = {
    //Eminence Delta_Demon

    {7, 38, 93, 1, 0, 7, 49, 65, 69, 0, 7, 57, 72, 65, 0, 7, 74, 89, 56, 0, 7,
     82, 81, 71, 0, 7, 90, 92, 56, 0, 7, 106, 68, 66, 0, 7, 114, 30, 25, 0, 7,
     117, 74, 72, 0, 7, 125, 19, 69, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0,
     64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 67},

    //Eminence Legend1058
    {7, 39, 97, 12, 0, 7, 57, 68, 64, 0, 7, 61, 66, 75, 0, 7, 68, 66, 64, 0,
     7, 77, 74, 50, 0, 7, 92, 114, 37, 0, 7, 51, 59, 64, 0, 7, 102, 77, 64, 0,
     7, 113, 47, 64, 0, 7, 119, 72, 69, 0, 7, 122, 0, 78, 0, 0, 64, 64, 64, 0,
     0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0,
     64},

    //Eminence Legend1258
    {4, 17, 64, 24, 0, 7, 40, 105, 24, 0, 7, 51, 68, 64, 0, 7, 72, 77, 43, 0,
     7, 81, 41, 72, 0, 7, 89, 112, 47, 0, 7, 94, 72, 64, 0, 7, 100, 74, 64, 0,
     7, 108, 50, 64, 0, 7, 110, 52, 87, 0, 7, 113, 59, 41, 0, 7, 117, 35, 69,
     0, 7, 121, 58, 99, 0, 7, 124, 47, 56, 0, 3, 125, 64, 31, 0, 0, 64, 64,
     64, 0, 67},

    //Eminence Legend1558
    {7, 39, 103, 0, 0, 7, 57, 71, 69, 0, 7, 61, 71, 78, 0, 7, 68, 68, 77, 0,
     7, 73, 84, 68, 0, 7, 77, 53, 28, 0, 7, 51, 62, 64, 0, 7, 87, 115, 47, 0,
     7, 91, 86, 71, 0, 7, 104, 50, 69, 0, 7, 108, 72, 95, 0, 0, 64, 64, 64, 0,
     7, 112, 52, 69, 0, 7, 114, 65, 100, 0, 7, 125, 47, 61, 0, 3, 125, 71, 25,
     0, 64},

    //Celestion Ainico Gold
    {7, 13, 64, 59, 0, 7, 39, 84, 65, 0, 7, 48, 80, 69, 0, 7, 69, 103, 22, 0,
     7, 82, 46, 65, 0, 7, 89, 89, 62, 0, 7, 94, 58, 77, 0, 7, 100, 103, 46, 0,
     7, 112, 30, 71, 0, 7, 113, 71, 90, 0, 7, 118, 46, 78, 0, 7, 119, 62, 103,
     0, 7, 121, 37, 74, 0, 7, 125, 64, 114, 0, 0, 64, 64, 64, 0, 7, 127, 15,
     114, 0, 67},

    //Celestion Vintage 30
    {4, 17, 64, 18, 0, 7, 21, 61, 83, 0, 7, 38, 81, 40, 0, 7, 51, 77, 32, 0,
     7, 77, 102, 7, 0, 7, 79, 55, 75, 0, 7, 84, 72, 53, 0, 7, 89, 78, 75, 0,
     7, 91, 74, 96, 0, 7, 100, 93, 35, 0, 7, 112, 19, 83, 0, 7, 120, 16, 44,
     0, 7, 125, 38, 81, 0, 7, 127, 52, 44, 0, 0, 124, 64, 87, 0, 0, 64, 64,
     64, 0, 67},

    //Celestion G12T-75
    {4, 13, 74, 28, 0, 7, 30, 59, 61, 0, 7, 38, 87, 30, 0, 7, 71, 100, 12, 0,
     7, 82, 46, 64, 0, 7, 90, 90, 75, 0, 7, 95, 92, 61, 0, 7, 100, 72, 64, 0,
     7, 104, 80, 75, 0, 7, 109, 38, 83, 0, 7, 115, 47, 74, 0, 7, 117, 40, 90,
     0, 7, 121, 27, 111, 0, 7, 125, 19, 105, 0, 7, 127, 52, 41, 0, 0, 64, 64,
     64, 0, 67},

    //Celestion G12-EVH
    {4, 1, 64, 24, 0, 7, 24, 59, 16, 0, 7, 38, 103, 32, 0, 7, 70, 81, 53, 0,
     7, 90, 121, 52, 0, 7, 108, 64, 69, 0, 7, 94, 95, 74, 0, 7, 110, 38, 40,
     0, 7, 115, 47, 81, 0, 7, 122, 30, 78, 0, 7, 127, 7, 93, 0, 0, 64, 64, 64,
     0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64,
     0, 67},

    //Celestion HG12-65
    {4, 13, 64, 31, 0, 7, 41, 99, 15, 0, 7, 70, 72, 43, 0, 7, 82, 43, 86, 0,
     7, 85, 95, 34, 0, 7, 96, 84, 71, 0, 7, 102, 71, 74, 0, 7, 105, 92, 95, 0,
     7, 110, 53, 90, 0, 7, 117, 35, 80, 0, 7, 121, 35, 106, 0, 7, 127, 15, 68,
     0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64, 0, 0, 64, 64, 64,
     0, 67},

    //Jensen6-15
    {7, 30, 93, 22, 0, 7, 57, 55, 40, 0, 7, 63, 74, 64, 0, 7, 67, 74, 86, 0,
     7, 76, 77, 80, 0, 7, 86, 90, 64, 0, 7, 92, 83, 78, 0, 7, 100, 92, 84, 0,
     7, 103, 92, 66, 0, 7, 107, 83, 83, 0, 7, 112, 99, 75, 0, 7, 116, 87, 75,
     0, 7, 125, 69, 87, 0, 3, 127, 68, 96, 0, 7, 45, 68, 86, 0, 7, 80, 72, 80,
     0, 64},

    //JensenP15-N
    {7, 39, 105, 12, 0, 7, 57, 59, 83, 0, 7, 68, 84, 64, 0, 7, 72, 71, 83, 0,
     7, 77, 89, 87, 0, 7, 85, 112, 77, 0, 7, 92, 102, 90, 0, 7, 100, 41, 64,
     0, 7, 110, 86, 75, 0, 7, 113, 40, 89, 0, 7, 116, 72, 81, 0, 7, 122, 46,
     81, 0, 7, 125, 66, 78, 0, 7, 126, 49, 90, 0, 7, 127, 28, 77, 0, 0, 64,
     64, 64, 0, 64},

    //JensenC15N
    {7, 8, 0, 1, 0, 7, 21, 115, 9, 0, 7, 38, 103, 49, 0, 7, 43, 71, 78, 0, 7,
     56, 77, 43, 0, 7, 67, 77, 52, 0, 7, 76, 77, 52, 0, 7, 85, 123, 31, 0, 7,
     91, 86, 66, 0, 7, 100, 41, 92, 0, 7, 104, 55, 44, 0, 7, 108, 78, 84, 0,
     7, 113, 28, 106, 0, 7, 116, 40, 66, 0, 7, 123, 21, 56, 0, 3, 126, 68, 69,
     0, 67},

    //Jensen-Neo-12-100
    {4, 11, 64, 0, 0, 7, 24, 65, 81, 0, 7, 39, 124, 7, 0, 7, 57, 61, 87, 0, 7,
     68, 80, 69, 0, 7, 76, 74, 89, 0, 7, 87, 99, 75, 0, 7, 91, 84, 78, 0, 7,
     97, 102, 66, 0, 7, 100, 81, 95, 0, 7, 111, 31, 55, 0, 7, 115, 58, 71, 0,
     7, 116, 43, 100, 0, 7, 118, 64, 87, 0, 7, 125, 32, 61, 0, 3, 127, 64, 50,
     0, 67}
  };


  if (npreset >= NUM_PRESETS)
    npreset = NUM_PRESETS - 1;
  for (int n = 0; n < 16; n++)
    {
      efx_Cabinet->changepar (n * 5 + 10, presets[npreset][n * 5]);
      efx_Cabinet->changepar (n * 5 + 11, presets[npreset][n * 5 + 1]);
      efx_Cabinet->changepar (n * 5 + 12, presets[npreset][n * 5 + 2]);
      efx_Cabinet->changepar (n * 5 + 13, presets[npreset][n * 5 + 3]);
      efx_Cabinet->changepar (n * 5 + 14, presets[npreset][n * 5 + 4]);

    }

  Cabinet_Preset = npreset;

  return (0);


};





int
RKR::EQ1_setpreset (int func, int num, unsigned char npreset)
{

  const int PRESET_SIZE = 12;
  const int NUM_PRESETS = 3;
  unsigned char presets[NUM_PRESETS][PRESET_SIZE] = {
    //Plain
    {64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64},
    //Pop
    {78, 71, 64, 64, 64, 64, 64, 64, 71, 80, 64, 42},
    //Jazz
    {71, 68, 64, 64, 64, 64, 64, 64, 66, 69, 64, 40}
  };

  if (func)
    return ((int) presets[npreset][num]);

  if (npreset >= NUM_PRESETS)
    npreset = NUM_PRESETS - 1;
  for (int n = 0; n < 10; n++)
    efx_EQ1->changepar (n * 5 + 12, presets[npreset][n]);
  efx_EQ1->changepar (0, presets[npreset][10]);
  for (int n = 0; n < 10; n++)
    efx_EQ1->changepar (n * 5 + 13, presets[npreset][11]);
  return (0);

};



int
RKR::EQ2_setpreset (int func, int num, unsigned char npreset)
{


  const int PRESET_SIZE = 10;
  const int NUM_PRESETS = 3;
  unsigned char presets[NUM_PRESETS][PRESET_SIZE] = {
    //Plain
    {24, 64, 64, 75, 64, 64, 113, 64, 64, 64},
    //Pop
    {24, 73, 45, 75, 64, 64, 113, 69, 38, 64},
    //Jazz
    {24, 71, 38, 75, 64, 64, 118, 69, 38, 64}
  };


  if (func)
    return ((int) presets[npreset][num]);

  if (npreset >= NUM_PRESETS)
    npreset = NUM_PRESETS - 1;
  for (int n = 0; n < 3; n++)
    {
      efx_EQ2->changepar (n * 5 + 11, presets[npreset][n * 3]);
      efx_EQ2->changepar (n * 5 + 12, presets[npreset][n * 3 + 1]);
      efx_EQ2->changepar (n * 5 + 13, presets[npreset][n * 3 + 2]);
    }
  efx_EQ2->changepar (0, presets[npreset][9]);
  return (0);
};


void
RKR::Vol2_Efx ()
{

  int i;

  for (i = 0; i < PERIOD; i++)
    {
      smpl[i] = efxoutl[i];
      smpr[i] = efxoutr[i];
    }

}


void
RKR::Vol3_Efx ()
{
  int i;

  for (i = 0; i < PERIOD; i++)
    {
      efxoutl[i] *= .1;
      smpl[i] = efxoutl[i];
      efxoutr[i] *= .1;
      smpr[i] = efxoutr[i];
    }

}


void
RKR::Vol_Efx (int NumEffect, float volume)
{
  int i;
  float v1, v2;

  if (volume < 0.5)
    {
      v1 = 1.0;
      v2 = volume * 2.0;
    }
  else
    {
      v1 = (1.0 - volume) * 2.0;
      v2 = 1.0;
    };


  if ((NumEffect == 6) || (NumEffect == 7) || (NumEffect == 12))
    v2 *= v2;


  for (i = 0; i < PERIOD; i++)
    {
      efxoutl[i] = smpl[i] * v2 + efxoutl[i] * v1;
      smpl[i] = efxoutl[i];
      efxoutr[i] = smpr[i] * v2 + efxoutr[i] * v1;
      smpr[i] = efxoutr[i];
    };


}


void
RKR::calculavol (int i)
{

  if (i == 1)
    Log_I_Gain = powf (Input_Gain * 2.0, 4);
  if (i == 2)
    Log_M_Volume = powf (Master_Volume * 2.0, 4);

}

void
RKR::Control_Gain ()
{

  int i;
  float i_sum = 1e-12;
  float temp_sum;
  float tmp;

  for (i = 0; i <= PERIOD; i++)
    {
      efxoutl[i] *= Log_I_Gain;
      smpl[i] = efxoutl[i];
      efxoutr[i] *= Log_I_Gain;
      smpr[i] = efxoutr[i];
      tmp = fabsf (efxoutr[i] + efxoutl[i]);
      if (tmp > i_sum)
	i_sum = tmp;
    }
  temp_sum = CLAMP (rap2dB (i_sum), -48.0, 15.0);
  val_i_sum = .6 * old_i_sum + .4 * temp_sum;
  val_sum = val_i_sum;



}


void
RKR::Control_Volume ()
{
  int i;
  float i_sum = 1e-12;
  float temp_sum;
  float tmp;

  for (i = 0; i <= PERIOD; i++)
    {
      efxoutl[i] += denormal[i];
      efxoutr[i] += denormal[i];
    }


  for (i = 0; i <= PERIOD; i++)
    {
      efxoutl[i] *= Log_M_Volume;
      efxoutr[i] *= Log_M_Volume;
      tmp = fabsf (efxoutr[i] + efxoutl[i]);
      if (tmp > i_sum)
	i_sum = tmp;
    }
  temp_sum = CLAMP (rap2dB (i_sum), -48, 15);
  if (i_sum > 0.000048) have_signal = 1; else have_signal = 0;
  val_v_sum = .6 * old_v_sum + .4 * temp_sum;


}


void
RKR::cleanup_efx ()
{
  efx_EQ1->cleanup ();
  efx_Rev->cleanup ();
  efx_Distorsion->cleanup ();
  efx_Overdrive->cleanup ();
  efx_Compressor->cleanup ();
  efx_Echo->cleanup ();
  efx_Chorus->cleanup ();
  efx_Flanger->cleanup ();
  efx_Phaser->cleanup ();
  efx_EQ2->cleanup ();
  efx_WhaWha->cleanup ();
  efx_Alienwah->cleanup ();
  efx_Cabinet->cleanup ();
  efx_Pan->cleanup ();
  efx_Har->cleanup ();
  efx_MusDelay->cleanup ();
  efx_Gate->cleanup ();
  RC->cleanup ();
};


void
RKR::Alg (float *inl1, float *inr1, void *)
{

  int i;

  efxoutl = inl1;
  efxoutr = inr1;


  if (Bypass)
    {

      Control_Gain ();

      if (Tuner_Bypass)
	efx_Tuner->schmittFloat (PERIOD, efxoutl, efxoutr);
      if (MIDIConverter_Bypass)
	efx_MIDIConverter->schmittFloat (PERIOD, efxoutl, efxoutr);

      if ((Harmonizer_Bypass) && (have_signal))
	{
	  if (efx_Har->mira)
	    {
	      if ((efx_Har->PMIDI) || (efx_Har->PSELECT))
		{
		  if (val_sum > -40.0)
		    RecNote->schmittFloat (efxoutl, efxoutr);
		  if ((reconota != -1) && (reconota != last))
		    {
		      RC->Vamos (efx_Har->Pinterval - 12);
		      last = reconota;
		    }
		}

	    }
	}

      
      for (i = 0; i < 10; i++)
	{
	  switch (efx_order[i])
	    {
	    case 0:
	      if ((EQ1_Bypass) && (have_signal))
		{
		  efx_EQ1->out (efxoutl, efxoutr);
		  Vol2_Efx ();
		}
	      break;

	    case 1:
	      if ((Compressor_Bypass)  && (have_signal))
		{
		  efx_Compressor->out (efxoutl, efxoutr);
		  Vol2_Efx ();
		}
	      break;

	    case 5:
	      if ((Chorus_Bypass) && (have_signal))
		{
		  efx_Chorus->out (efxoutl, efxoutr);
		  Vol_Efx (1, efx_Chorus->outvolume);
		}
	      break;

	    case 7:
	      if ((Flanger_Bypass) && (have_signal))
		{
		  efx_Flanger->out (efxoutl, efxoutr);
		  Vol_Efx (2, efx_Flanger->outvolume);
		}
	      break;

	    case 6:
	      if ((Phaser_Bypass)  && (have_signal))
		{
		  efx_Phaser->out (efxoutl, efxoutr);
		  Vol_Efx (3, efx_Phaser->outvolume);
		}
	      break;

	    case 2:
	      if ((Distorsion_Bypass)  && (have_signal))
		{
		  efx_Distorsion->out (efxoutl, efxoutr);
		  Vol_Efx (4, efx_Distorsion->outvolume);
		}
	      break;

	    case 3:
	      if ((Overdrive_Bypass)  && (have_signal))
		{
		  efx_Overdrive->out (efxoutl, efxoutr);
		  Vol_Efx (5, efx_Overdrive->outvolume);
		}
	      break;

	    case 4:
	      if ((Echo_Bypass)  && (have_signal))
		{
		  efx_Echo->out (efxoutl, efxoutr);
		  Vol_Efx (6, efx_Echo->outvolume);
		}
	      break;
	    case 8:
	      if ((Reverb_Bypass) && (have_signal))
		{
		  efx_Rev->out (efxoutl, efxoutr);
		  Vol_Efx (7, efx_Rev->outvolume);
		}
	      break;

	    case 9:
	      if ((EQ2_Bypass)  && (have_signal))
		{
		  efx_EQ2->out (efxoutl, efxoutr);
		  Vol2_Efx ();
		}
	      break;

	    case 10:
	      if ((WhaWha_Bypass)   && (have_signal))
		{
		  efx_WhaWha->out (efxoutl, efxoutr);
		  Vol_Efx (8, efx_WhaWha->outvolume);
		}
	      break;

	    case 11:
	      if ((Alienwah_Bypass)  && (have_signal))
		{
		  efx_Alienwah->out (efxoutl, efxoutr);
		  Vol_Efx (9, efx_Alienwah->outvolume);
		}
	      break;

	    case 12:
	      if ((Cabinet_Bypass)  && (have_signal))
		{
		  efx_Cabinet->out (efxoutl, efxoutr);
		  Vol3_Efx ();
		}

              break; 

	    case 13:
	      if ((Pan_Bypass)  && (have_signal))
		{
		  efx_Pan->out (efxoutl, efxoutr);
		  Vol_Efx (10, efx_Pan->outvolume);
		}
	      break;

	    case 14:
	      if ((Harmonizer_Bypass)  && (have_signal))
		{
		  efx_Har->out (efxoutl, efxoutr);
		  Vol_Efx (11, efx_Har->outvolume);
		}
	      break;

	    case 15:
	      if ((MusDelay_Bypass)  && (have_signal))
		{
		  efx_MusDelay->out (efxoutl, efxoutr);
		  Vol_Efx (12, efx_MusDelay->outvolume);
		}
	      break;

	    case 16:
	      if ((Gate_Bypass) && (have_signal))
		{
		  efx_Gate->out (efxoutl, efxoutr);
		  Vol2_Efx ();
		}
	      break;

	    }
	}

      
      Control_Volume ();


    }


}
