/*
  rakarrack - a guitar effects software

 rkrMIDI.C  -  MIDI functions
  Copyright (C) 2008 Daniel Vidal & Josep Andreu
  Author: Daniel Vidal & Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#include "global.h"


void
RKR::InitMIDI ()
{

  // Open Alsa Seq

  int alsaport_in;

  int err = snd_seq_open (&midi_in, "default", SND_SEQ_OPEN_INPUT, 0);
  if (err < 0)
    printf ("Cannot activate ALSA seq client\n");
  snd_seq_set_client_name (midi_in, "rakarrack");
  snd_config_update_free_global ();



  char portname[50];

  // Create Alsa Seq Client

  sprintf (portname, "rakarrack IN");
  alsaport_in = snd_seq_create_simple_port (midi_in, portname,
					    SND_SEQ_PORT_CAP_WRITE |
					    SND_SEQ_PORT_CAP_SUBS_WRITE,
					    SND_SEQ_PORT_TYPE_SYNTH);


}



void
RKR::miramidi ()
{

  if (snd_seq_event_input_pending (midi_in, 1))
    {
      do
	{
	  midievents (1);

	}
      while (snd_seq_event_input_pending (midi_in, 0));
    }

};








void
RKR::midievents (int keIN)
{

  int i;
  snd_seq_event_t *midievent;
  midievent = NULL;
  snd_seq_event_input (midi_in, &midievent);
  if (midievent == NULL)
    return;
  if (midievent->type == 42)
    return;



  if ((midievent->type == SND_SEQ_EVENT_NOTEON)
      || (midievent->type == SND_SEQ_EVENT_NOTEOFF))
    {
      int cmdnote = midievent->data.note.note;
      int cmdvelo = midievent->data.note.velocity;

      if (midievent->data.note.channel == HarCh)
	{
	  for (i = 0; i < POLY; i++)
	    {
	      if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo != 0))
		{
		  if (note_active[i] == 0)
		    {
		      note_active[i] = 1;
		      rnote[i] = cmdnote;
		      gate[i] = 1;
		      RC->MiraChord ();
		      break;
		    }

		}


	      if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo == 0))
		{

		  if ((note_active[i]) && (rnote[i] == cmdnote))
		    {
		      note_active[i] = 0;
		      gate[i] = 0;
		      break;
		    }

		}


	      if (midievent->type == SND_SEQ_EVENT_NOTEOFF)
		{

		  if ((note_active[i]) && (rnote[i] == cmdnote))
		    {
		      note_active[i] = 0;
		      gate[i] = 0;
		      break;
		    }

		}
	    }



	}


    }





  if (midievent->type == SND_SEQ_EVENT_PGMCHANGE)
    {

      if (midievent->data.control.channel == MidiCh)
	{
	  if ((midievent->data.control.value > 0)
	      && (midievent->data.control.value < 81))
	    preset = midievent->data.control.value;
	}
    }



  if (midievent->type == SND_SEQ_EVENT_CONTROLLER)
    {
      if (midievent->data.control.channel == MidiCh)
	{

	  switch ((int) midievent->data.control.param)
	    {

	    case 7:

	      if (Bypass)
		{
		  Master_Volume =
		    (float) midievent->data.control.value / 128.0;
		  calculavol (2);
		  midivol = 1;
		}
	      break;

	    case 1:

	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (6,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[1] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 20:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (6,
					   (unsigned char) midievent->data.
					   control.value);
		  Mcontrol[20] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 21:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (6,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[21] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 22:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (6,
					  (unsigned char) midievent->data.
					  control.value);
		  Mcontrol[22] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 23:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (6,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[23] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 24:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (11,
					   (int) midievent->data.control.
					   value);
		  Mcontrol[24] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 25:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (12,
					   (int) midievent->data.control.
					   value);
		  Mcontrol[25] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 26:
	      if (Harmonizer_Bypass)
		{
		  efx_Har->changepar (4,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[26] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 27:
	      if (Harmonizer_Bypass)
		{
		  Harmonizer_Bypass = 0;
		  efx_Har->changepar (3,
				      (unsigned char) (.189 *
						       midievent->data.
						       control.value));
		  Harmonizer_Bypass = 1;
		  Mcontrol[27] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 28:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (0,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[28] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 29:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (0,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[29] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 30:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (0,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[30] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 31:
	      if (Harmonizer_Bypass)
		{
		  efx_Har->changepar (0,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[31] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 52:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (0,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[52] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 53:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (0,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[53] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 54:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (0,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[54] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 55:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (0,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[55] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 56:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (0,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[56] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 57:
	      if (Reverb_Bypass)
		{
		  efx_Rev->changepar (0,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[57] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 58:
	      if (Pan_Bypass)
		{
		  efx_Pan->changepar (0,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[58] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 59:
	      if (Echo_Bypass)
		{
		  efx_Echo->changepar (0,
				       (unsigned char) midievent->
				       data.control.value);
		  Mcontrol[59] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 46:
	      if (Echo_Bypass)
		{
		  efx_Echo->changepar (1,
				       (unsigned char) midievent->
				       data.control.value);
		  Mcontrol[46] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 47:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (1,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[47] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 48:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (1,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[48] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 49:
	      if (Harmonizer_Bypass)
		{
		  efx_Har->changepar (1,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[49] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 50:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (1,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[50] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 51:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (1,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[51] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 60:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (1,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[60] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 61:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (1,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[61] = 1;
		  Mvalue = 1;
		} 
	      break;

	    case 62:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (1,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[62] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 63:
	      if (Reverb_Bypass)
		{
		  efx_Rev->changepar (1,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[63] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 65:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (7,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[65] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 66:

	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (1,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[66] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 67:
	      if (Pan_Bypass)
		{
		  efx_Pan->changepar (1,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[67] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 68:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (3,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[68] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 69:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (3,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[69] = 1;
		  Mvalue = 1;
		}
	      break;
	    case 70:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (4,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[70] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 71:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (4,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[71] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 72:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (2,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[72] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 73:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (2,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[73] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 74:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (2,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[74] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 75:

	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (2,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[75] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 76:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (2,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[76] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 77:
	      if (Pan_Bypass)
		{
		  efx_Pan->changepar (2,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[77] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 78:
	      if (Echo_Bypass)
		{
		  efx_Echo->changepar (5,
				       (unsigned char) midievent->
				       data.control.value);
		  Mcontrol[78] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 79:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (8,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[79] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 80:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (8,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[80] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 81:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (7,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[81] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 82:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (7,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[82] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 83:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (5,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[83] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 84:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (9,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[84] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 85:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (7,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[85] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 86:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (7,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[86] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 87:
	      if (Reverb_Bypass)
		{
		  efx_Rev->changepar (7,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[87] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 88:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (8,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[88] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 89:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (8,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[89] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 90:
	      if (Reverb_Bypass)
		{
		  efx_Rev->changepar (8,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[90] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 91:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (9,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[91] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 92:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (9,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[92] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 93:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (9,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[93] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 94:
	      if (Overdrive_Bypass)
		{
		  efx_Overdrive->changepar (2,
					    (unsigned char) midievent->
					    data.control.value);
		  Mcontrol[94] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 95:
	      if (Distorsion_Bypass)
		{
		  efx_Distorsion->changepar (2,
					     (unsigned char) midievent->
					     data.control.value);
		  Mcontrol[95] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 96:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (9,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[96] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 97:
	      if (Echo_Bypass)
		{
		  efx_Echo->changepar (4,
				       (unsigned char) midievent->
				       data.control.value);
		  Mcontrol[97] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 98:
	      if (MusDelay_Bypass)
		{
		  efx_MusDelay->changepar (4,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[98] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 99:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (5,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[99] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 100:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (5,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[100] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 101:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (5,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[101] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 102:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (5,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[102] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 103:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (5,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[103] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 104:
	      if (Pan_Bypass)
		{
		  efx_Pan->changepar (5,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[104] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 105:
	      if (Chorus_Bypass)
		{
		  efx_Chorus->changepar (3,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[105] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 106:
	      if (Flanger_Bypass)
		{
		  efx_Flanger->changepar (3,
					  (unsigned char) midievent->
					  data.control.value);
		  Mcontrol[106] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 107:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (3,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[107] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 108:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (3,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[108] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 109:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (3,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[109] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 110:
	      if (Pan_Bypass)
		{
		  efx_Pan->changepar (3,
				      (unsigned char) midievent->data.
				      control.value);
		  Mcontrol[110] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 111:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (7,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[111] = 1;
		  Mvalue = 1;
		}
	      break;
	    case 112:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (8,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[112] = 1;
		  Mvalue = 1;
		}
	      break;
	      
	    case 113:
	      if (WhaWha_Bypass)
		{
		  efx_WhaWha->changepar (9,
					 (unsigned char) midievent->data.
					 control.value);
		  Mcontrol[113] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 114:
	      if (Phaser_Bypass)
		{
		  efx_Phaser->changepar (11,
					 (unsigned char) midievent->
					 data.control.value);
		  Mcontrol[114] = 1;
		  Mvalue = 1;
		}
	      break;

	    case 115:
	      if (Alienwah_Bypass)
		{
		  efx_Alienwah->changepar (10,
					   (unsigned char) midievent->
					   data.control.value);
		  Mcontrol[115] = 1;
		  Mvalue = 1;
		}
	      break;

	    }
	}

    }



};



void
RKR::Conecta ()
{

  FILE *fp;

  int client = 0;
  int puerto = 0;
  char temp[128];
  char temp1[128];
  char temp2[128];
  char *nume;

  if (IsCoIn)
    disconectaaconnect ();


  if ((fp = fopen ("/proc/asound/seq/clients", "r")) != NULL)
    {
      bzero (temp, sizeof (temp));

      while (fgets (temp, sizeof temp, fp) != NULL)
	{

	  if (strstr (temp, "Client") != NULL)

	    {

	      strcpy (temp1, temp);
	      strtok (temp1, " ");
	      nume = strtok (NULL, "\"");
	      sscanf (nume, "%d", &client);

	    }

	  if (strstr (temp, "Port") != NULL)
	    {
	      strcpy (temp2, temp);
	      strtok (temp2, " ");
	      nume = strtok (NULL, "  ");
	      sscanf (nume, "%d", &puerto);
	      if (strstr (temp, "rakarrack IN") != 0)
		{
		  Cyoin = client;
		  Pyoin = puerto;
		}
	      if (strstr (temp, MID) != 0)
		{
		  Ccin = client;
		  Pcin = puerto;
		}

	    }
	}
    }

  fclose (fp);
  conectaaconnect ();
};




void
RKR::conectaaconnect ()
{
  char tempi[128];

  if (MID != NULL)
    {
      bzero (tempi, sizeof (tempi));
      sprintf (tempi, "aconnect %d:%d  %d:%d", Ccin, Pcin, Cyoin, Pyoin);
      system (tempi);
      IsCoIn = 1;
    }

};


void
RKR::disconectaaconnect ()
{
  char tempi[128];

  if (MID != NULL)
    {
      bzero (tempi, sizeof (tempi));
      sprintf (tempi, "aconnect -d %d:%d  %d:%d", Ccin, Pcin, Cyoin, Pyoin);
      system (tempi);
      IsCoIn = 0;
    }


};
