/* ================================ rand =================================
Name: rand
e-mail: gulyan89@yahoo.com
Start date: 30 November - 2008

Copyright (c)  2008		Guduleasa Alexandru Ionut
				<gulyan89@yahoo.com>


    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define VERSION "1.0.3"
#define DATE __DATE__
#define AUTHORS "Guduleasa Alexandru Ionut <gulyan89@yahoo.com>"
#define LICENCE "GPL v3 or any later"

static unsigned seed;
static unsigned max;
static unsigned int flt;
static int N;
static int escape;
static int prec;
static char eof[512];
static char bof[512];
static char delimiter[512];
static char mask[512];
static int max_set = 0;
static int n_stack_vf = -1;
static int *number_stack = NULL;

void print_random()
{
	int r = rand();
	if(flt == 0)r %= max;
	if(n_stack_vf>=0){
		int i;
		do{
			r = rand();
			if(flt == 0)r %= max;
			for(i=0; i < n_stack_vf; i++)
				if(number_stack[i] == r){
					r = -1;
					i = n_stack_vf;
				}
		}while(r == -1);
		number_stack[n_stack_vf++] = r;
	}
	if(flt == 0){
		if( mask[0] == 0 )printf("%d", r);
		else printf("%c", mask[r % strlen(mask)]);
	}
	else{
		char str[10];
		sprintf( str, "%%.%df", prec);
		printf(str, (double)r/(double)RAND_MAX);
	}
}

void clean()
{
	if(number_stack != NULL)free (number_stack);
}

void print_error(char *s)
{
	fprintf(stderr, "%s", s);//write to standart error
	clean();
	exit( 1 );
}

int num(char *s)
{
	int n = strlen(s);
	int i;
	for(i=0; i < n; i++)
		if(s[i] <'0' || s[i] >'9')return 0;
	return 1;
}

char escape_ch(char ch)
{
	switch (ch){
		case 'a':return '\a';
		case 'b':return '\b';
		case 'f':return '\f';
		case 'n':return '\n';
		case 'r':return '\r';
		case 't':return '\t';
		case 'v':return '\v';
		case '\\':return '\\';
	}
	return (char)-1;
}

void InitValues()
{
	seed = (unsigned) time( NULL );
	max = 32576;
	flt = 0;
	prec = 5;
	escape = 0;
	strcpy(bof, "");
	sprintf(eof, "%s", "\n");
	sprintf(delimiter, "%s", " ");
	strcpy(mask, "");
	N = 1;
}

void SyncronizeValues()
{
	char str[100];
	//parameters compatibility
	if( max_set && flt )return print_error("rand: can not use -M (--max) option with -f (-p) option -- \n");
	if( mask[0] && flt )return print_error("rand: can not use --mask option with -f (-p) option -- \n[Can not mask floating numbers.]\n");
	//set stack if necesary
	if( n_stack_vf >=0 ){
		if( max < N )return print_error("rand: to many unique numbers to generate.\n");
		number_stack = (int *)malloc(N*sizeof(int));
	}
	//escape characters for eof, bof, delimiter
	if(escape){
		//delimiter
		strcpy( str, delimiter);
		int i, j;
		int n = strlen(delimiter);
		for(i = j = 0; i < n; i++, j++){
			if(str[i]!='\\')delimiter[j] = str[i];
			else {
				i++;
				delimiter[j] = escape_ch(str[i]);
				if(delimiter[j] == -1){
					sprintf(str, "rand: unknown escape character -- '\\%c'\n", str[i]);
					return print_error(str);
				}
			}
		}
		delimiter[j] = '\0';
		//eof
		strcpy( str, eof);
		n = strlen(eof);
		for(i = j = 0; i < n; i++, j++){
			if(str[i]!='\\')eof[j] = str[i];
			else {
				i++;
				eof[j] = escape_ch(str[i]);
				if(eof[j] == -1){
					sprintf(str, "rand: unknown escape character -- '\\%c'\n", str[i]);
					return print_error(str);
				}
			}
		}
		eof[j] = '\0';
		//bof
		strcpy( str, bof);
		n = strlen(bof);
		for(i = j = 0; i < n; i++, j++){
			if(str[i]!='\\')bof[j] = str[i];
			else {
				i++;
				bof[j] = escape_ch(str[i]);
				if(bof[j] == -1){
					sprintf(str, "rand: unknown escape character -- '\\%c'\n", str[i]);
					return print_error(str);
				}
			}
		}
		bof[j] = '\0';
	}
}

void CLIF_Parse(int argc, char *argv[])
{
	int i;
	char str[100];
	for( i = 1; i < argc; i++){
		//Count of random numbers to generate
		if(strcmp(argv[i], "-N") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'N'\n");
			else if(num(argv[i]))sscanf(argv[i], "%d", &N);
			else return print_error("rand: argument must be a number -- 'N'\n");
		}
		//Float numbers between 0 and 1
		else if(strcmp(argv[i], "-f") == 0){
			flt = 1;
		}
		//Precison of float numbers between 0 and 1
		else if(strcmp(argv[i], "-p") == 0){
			i++;
			flt = 1;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'p'\n");
			else if(num(argv[i])){
				sscanf(argv[i], "%d", &prec);
				if (prec < 1 || prec > 50)
					return print_error("rand: argument must be between 1 AND 50 -- 'p'\n");
			}
			else return print_error("rand: argument must be a number -- 'p'\n");
		}
		//Show unique numbers only
		else if(strcmp(argv[i], "-u") == 0 || strcmp(argv[i], "--unique") == 0){
			n_stack_vf = 0;//-1 for not unique
		}
		//Maximum for decimal numbers (default 32576)
		else if(strcmp(argv[i], "-M") == 0 || strcmp(argv[i], "--max") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'M'\n");
			else if(num(argv[i])){
				sscanf(argv[i], "%d", &max);
				max_set = 1;
			}
			else return print_error("rand: argument must be a number -- 'M'\n");
		}
		//Seed for the random numbers generator (default time(NULL) )
		else if(strcmp(argv[i], "-s") == 0 || strcmp(argv[i], "--seed") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 's'\n");
			else if(num(argv[i])) sscanf(argv[i], "%d", &seed);
			else return print_error("rand: argument must be a number -- 's'\n");
		}
		//delimiter => what to print between the numbers (default SPACE)
		else if(strcmp(argv[i], "-d") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'd'\n");
			else sprintf(delimiter, "%s", argv[i]);
		}
		//What to print ant the end of the program (default "\n")
		else if(strcmp(argv[i], "--eof") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'eof'\n");
			else sprintf(eof, "%s", argv[i]);
		}
		//What to print ant the beginning of the program (default "\n")
		else if(strcmp(argv[i], "--bof") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'bof'\n");
			else sprintf(bof, "%s", argv[i]);
		}
		//mask numbers
		else if(strcmp(argv[i], "--mask") == 0){
			i++;
			if( i >= argc )
				return print_error("rand: option requires an argument -- 'mask'\n");
			else sprintf(mask, "%s", argv[i]);
		}
		//Interpret escape characters
		else if(strcmp(argv[i], "-e") == 0){
			escape = 1;
		}
		//Do not interpret escape characters
		else if(strcmp(argv[i], "-E") == 0){
			escape = 0;
		}
		//Version & date of compilation
		else if(strcmp(argv[i], "--version") == 0){
			printf("Random numbers generator for GNU/Linux, version %s, %s\nCopyright (c) 2008  %s\nLicense: %s\n", VERSION, DATE, AUTHORS, LICENCE);
			exit( 0 );
		}
		//Unknown
		else{
			sprintf(str, "rand: unknown option -- '%s'\n", argv[i]);
			return print_error(str);
		}
	}
}

int main(int argc, char *argv[])
{
	InitValues();
	CLIF_Parse(argc, argv);
	SyncronizeValues();
	srand( seed );
	int i;
	printf("%s", bof);
	for( i=0; i < N; i++){
		print_random();
		printf("%s", (i < N-1?delimiter:eof));
	}
	clean();
	return 0;
}
