/// \file
// Range v3 library
//
//  Copyright Eric Niebler 2013-present
//
//  Use, modification and distribution is subject to the
//  Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt)
//
// Project home: https://github.com/ericniebler/range-v3
//

#ifndef RANGES_V3_VIEW_HPP
#define RANGES_V3_VIEW_HPP

#include <range/v3/detail/config.hpp>
RANGES_DISABLE_WARNINGS

#include <range/v3/view/adaptor.hpp>
#include <range/v3/view/addressof.hpp>
#include <range/v3/view/adjacent_filter.hpp>
#include <range/v3/view/adjacent_remove_if.hpp>
#include <range/v3/view/all.hpp>
#include <range/v3/view/any_view.hpp>
#include <range/v3/view/c_str.hpp>
#include <range/v3/view/cartesian_product.hpp>
#include <range/v3/view/chunk.hpp>
#include <range/v3/view/common.hpp>
#include <range/v3/view/concat.hpp>
#include <range/v3/view/const.hpp>
#include <range/v3/view/counted.hpp>
#include <range/v3/view/cycle.hpp>
#include <range/v3/view/delimit.hpp>
#include <range/v3/view/drop.hpp>
#include <range/v3/view/drop_exactly.hpp>
#include <range/v3/view/drop_last.hpp>
#include <range/v3/view/drop_while.hpp>
#include <range/v3/view/empty.hpp>
#include <range/v3/view/enumerate.hpp>
#include <range/v3/view/exclusive_scan.hpp>
#include <range/v3/view/facade.hpp>
#include <range/v3/view/filter.hpp>
#include <range/v3/view/for_each.hpp>
#include <range/v3/view/generate.hpp>
#include <range/v3/view/generate_n.hpp>
#include <range/v3/view/getlines.hpp>
#include <range/v3/view/group_by.hpp>
#include <range/v3/view/indices.hpp>
#include <range/v3/view/indirect.hpp>
#include <range/v3/view/intersperse.hpp>
#include <range/v3/view/iota.hpp>
#include <range/v3/view/istream.hpp>
#include <range/v3/view/join.hpp>
#include <range/v3/view/linear_distribute.hpp>
#include <range/v3/view/map.hpp>
#include <range/v3/view/move.hpp>
#include <range/v3/view/partial_sum.hpp>
#include <range/v3/view/ref.hpp>
#include <range/v3/view/remove_if.hpp>
#include <range/v3/view/repeat.hpp>
#include <range/v3/view/repeat_n.hpp>
#include <range/v3/view/replace.hpp>
#include <range/v3/view/replace_if.hpp>
#include <range/v3/view/reverse.hpp>
#include <range/v3/view/sample.hpp>
#include <range/v3/view/set_algorithm.hpp>
#include <range/v3/view/single.hpp>
#include <range/v3/view/slice.hpp>
#include <range/v3/view/sliding.hpp>
#include <range/v3/view/span.hpp>
#include <range/v3/view/split.hpp>
#include <range/v3/view/split_when.hpp>
#include <range/v3/view/stride.hpp>
#include <range/v3/view/subrange.hpp>
#include <range/v3/view/tail.hpp>
#include <range/v3/view/take.hpp>
#include <range/v3/view/take_exactly.hpp>
#include <range/v3/view/take_last.hpp>
#include <range/v3/view/take_while.hpp>
#include <range/v3/view/tokenize.hpp>
#include <range/v3/view/transform.hpp>
#include <range/v3/view/trim.hpp>
#include <range/v3/view/unbounded.hpp>
#include <range/v3/view/unique.hpp>
#include <range/v3/view/view.hpp>
#include <range/v3/view/zip.hpp>
#include <range/v3/view/zip_with.hpp>

RANGES_RE_ENABLE_WARNINGS

#endif
