<?xml version="1.0" encoding="iso-8859-1"?>
<!--
	Name: $RCSfile: rapple.xsl,v $
	Author: Alan Moran
	$Date: 2005/11/20 13:36:27 $
	$Revision: 1.2 $
	$Id: rapple.xsl,v 1.2 2005/11/20 13:36:27 a_j_moran Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.
-->
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 	xmlns:rpl="http://rapple.sourceforge.net/2005/xhtml"
	xmlns:xhtml="http://www.w3.org/1999/xhtml"
	exclude-result-prefixes="rpl"
	version="1.0">

  <xsl:output
    method="xml"
    version="1.0"
    indent="yes"
	omit-xml-declaration="yes"
    encoding="iso-8859-1"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
  />

<xsl:param name="host"/>

<xsl:include href="file:///abs/path/to/librapple.xsl" />

<xsl:template match="/">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	  <head>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    		<title>
			<xsl:choose>
				<xsl:when test="xhtml:html/xhtml:head/xhtml:title/text()">
					<xsl:value-of select="xhtml:html/xhtml:head/xhtml:title"/>
				</xsl:when>
				<xsl:otherwise>
					Untitled.
				</xsl:otherwise>
			</xsl:choose>
			</title>
    		<link rel="stylesheet" type="text/css" href="{$host}rapple.css"/>
	</head>
	<body  bgcolor="FFFFFF">
	<br />
	<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td align="left" valign="middle">
				<img src="{$host}images/rapple.png" width="150" height="122" alt="logo" />
			</td>
			<td>
				<!-- &#xA0; -->
			</td>
			<td align="right">
				<b>rapple website generator</b>
			</td>
		</tr>
	</table>
	<br />

	<table width="100%"  border="0" cellspacing="0" cellpadding="0">
  		<tr>
    		<td valign="middle" align="center" bgcolor="#770000">
				<span class="banner">
					rapple, a lightweight XML based tool for creating standards based websites.
				</span>
			</td>
  		</tr>
	</table>

	<table border="0" width="100%" cellspacing="0" cellpadding="0">
	<tr>
	    <td valign="top" width="130">
			<br />
			<xsl:call-template name="librapple_generateMenu">
				<xsl:with-param name="menuFile" select="'rapple_menu.html'" />
			</xsl:call-template>
			<br />
		</td>
		<td bgcolor="ffffff" valign="top">
			<table border="0" cellpadding="8" cellspacing="0">
				<tr>
					<td valign="top">
						<xsl:apply-templates select="xhtml:html/xhtml:body/*" />
					</td>
				</tr>
			</table>
		</td>
	</tr>
	</table>
	
	<table width="100%"  border="0" cellspacing="0" cellpadding="0">
  		<tr>
    		<td valign="middle" bgcolor="#770000" align="center">
				<span class="banner">
					Website Design by Alan Moran, Copyright (c) 2005
				</span>
			</td>
  		</tr>
	</table>

	<br />
	<table border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td width="70">
				<a href="http://rapple.sourceforge.net/">
					<img border="0" height="31" src="{$host}images/pwrapple.png" alt="powered by rapple"/>
				</a>
			</td>
			<td width="90">
				<a href="http://sourceforge.net/">
				<img border="0" height="31" width="88" 
					src="http://sourceforge.net/sflogo.php?group_id=129927&amp;type=1" 
					alt="SourceForge.net Logo" /></a>
			</td>
			<td width="90">
				<a href="http://validator.w3.org/check/referer">
				<img border="0" height="31" width="88" src="{$host}images/valid-xhtml10.gif" 
					alt="Valid XHTML 1.0!" /></a>
			</td>
			<td width="90">
				<a href="http://jigsaw.w3.org/css-validator">
				<img border="0" height="31" width="88" src="{$host}images/vcss.gif" 
					alt="Valid CSS!" /></a>
			</td>
		</tr>
	</table>
</body>
</html>

</xsl:template>

<xsl:template match="node() | @*">
	<xsl:copy>
		<xsl:apply-templates select="node() | @*" />
	</xsl:copy>
</xsl:template>

</xsl:stylesheet>

