/*
   Name: $RCSfile: confp.h,v $
   Author: Alan Moran
   $Date: 2005/11/26 15:21:09 $
   $Revision: 1.14 $
   $Id: confp.h,v 1.14 2005/11/26 15:21:09 a_j_moran Exp $

   Description:
   Function prototypes and macros to support configuration parsing.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_CONFP_H
#define INCLUDE_CONFP_H

BEGIN_C_DECLS

#define RPL_CFG_ENV_VAR            "RAPPLE_CONF"
#define RPL_CFG_DEFAULT_FILE_NAME  "rapple.conf"

#define RPL_CFG_FILE_NOT_FOUND       -1
#define RPL_CFG_PARSE_ERROR          -2

int              rpl_cfg_parse(rpl_str_t cfg_filename);

rpl_str_t        rpl_cfg_get_config_filename(void);

rpl_str_t        rpl_cfg_get_logfile(void);
int              rpl_cfg_get_loglevel(void);

rpl_str_t        rpl_cfg_get_ds_basedir(void);

rpl_str_t 		 rpl_cfg_get_srcdir(void);
rpl_str_t 		 rpl_cfg_get_webdir(void);

rpl_str_t        rpl_cfg_get_trf_tidy_config(void);
rpl_str_t        rpl_cfg_get_trf_tpl_domain(void);
rpl_str_t        rpl_cfg_get_trf_tpl_xslt(void);
rpl_str_t        rpl_cfg_get_trf_catalog(void);

rpl_str_t 		 rpl_cfg_get_linkchecker_xslt(void);
rpl_str_t 		 rpl_cfg_get_linkchecker_xml_report(void);
rpl_str_t 		 rpl_cfg_get_linkchecker_html_report(void);

rpl_list *       rpl_cfg_get_dg_dir_names(void);
rpl_list *       rpl_cfg_get_dg_dir_titles(void);
void             rpl_cfg_cleanup(void);

rpl_str_t 		 rpl_cfg_get_db_name(void);
rpl_str_t 		 rpl_cfg_get_db_host(void);
int 			 rpl_cfg_get_db_port(void);
rpl_str_t  		 rpl_cfg_get_db_user(void);
rpl_str_t  		 rpl_cfg_get_db_pwd(void);

END_C_DECLS

#endif
