/*
   Name: $RCSfile: fsutil.h,v $
   Author: Alan Moran
   $Date: 2005/09/16 21:31:54 $
   $Revision: 1.8 $
   $Id: fsutil.h,v 1.8 2005/09/16 21:31:54 a_j_moran Exp $

   Description:
   Function prototypes to support filesystem utilities.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_FSUTIL_H
#define INCLUDE_FSUTIL_H

BEGIN_C_DECLS

#include "webasset.h"
#include "workflow.h"
#include "registry.h"

/* 4.3+BSD defines this and is required (p412) */
#ifndef MAP_FILE
#define MAP_FILE
#endif

#define RPL_FS_CWD_BUF_SIZE 512

rpl_str_t   	rpl_fs_f2str(rpl_c_str_t f_in);
void        	rpl_fs_str2f(rpl_c_str_t sout, rpl_c_str_t filename);
void        	rpl_fs_mkdir(rpl_c_str_t path);
void 			rpl_fs_cp(rpl_c_str_t from_filename, rpl_c_str_t to_filename);
void        	rpl_fs_remove(rpl_c_str_t filename);
void 			rpl_fs_delete_ds(void);
rpl_str_t   	rpl_fs_get_cwd(void);
int         	rpl_fs_file_exists(rpl_str_t filename);
rpl_str_t   	rpl_fs_normalize_path(rpl_str_t path);
void 			rpl_fs_recurse(rpl_c_str_t filename, rpl_mod_process_fp process);
int 			rpl_fs_resolve_paths(rpl_c_str_t abs_filename, rpl_c_str_t basedir, rpl_str_t *rel_dir, rpl_str_t *file);

END_C_DECLS

#endif
