/*
   Name: $RCSfile: strutil.h,v $
   Author: Alan Moran
   $Date: 2005/09/16 21:31:54 $
   $Revision: 1.7 $
   $Id: strutil.h,v 1.7 2005/09/16 21:31:54 a_j_moran Exp $

   Description:
   Function prototypes for string related utilities.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_STRUTIL_H
#define INCLUDE_STRUTIL_H

BEGIN_C_DECLS

#define RPL_STR_NUL "\0"
#define RPL_STR_EOC ((rpl_str_t) NULL)

/* signed string type required (e.g., to recognise EOF) */
typedef char *          rpl_str_t;
/* type qualifiers (but not specifiers) may be combined with typedefs (5.10) - this decl. is merely for convenience */
typedef const char *    rpl_c_str_t;

rpl_str_t   rpl_str_concat(rpl_c_str_t start, ...);
size_t      rpl_str_index_of(rpl_c_str_t str, char c);
void        rpl_str_split(rpl_c_str_t str, char delim, rpl_str_t *key, rpl_str_t *value);
void        rpl_str_rsplit(rpl_c_str_t str, char delim, rpl_str_t *key, rpl_str_t *value);

END_C_DECLS

#endif
