// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from StateSensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class StateSensor_4_0_5 : Com.Raritan.Idl.sensors.Sensor_4_0_5 {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.StateSensor:4.0.5", null);

    public StateSensor_4_0_5(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public StateSensor_4_0_5(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new StateSensor_4_0_5 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new StateSensor_4_0_5(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class State : ICloneable {
      public object Clone() {
        State copy = new State();
        copy.timestamp = this.timestamp;
        copy.available = this.available;
        copy.value = this.value;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["available"] = this.available;
        json["value"] = this.value;
        return json;
      }

      public static State Decode(LightJson.JsonObject json, Agent agent) {
        State inst = new State();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.available = (bool)json["available"];
        inst.value = (int)json["value"];
        return inst;
      }

      public System.DateTime timestamp = new System.DateTime(0);
      public bool available = false;
      public int value = 0;
    }

    public class StateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.StateSensor_4_0_5.StateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.sensors.StateSensor_4_0_5.State oldState = new Com.Raritan.Idl.sensors.StateSensor_4_0_5.State();
      public Com.Raritan.Idl.sensors.StateSensor_4_0_5.State newState = new Com.Raritan.Idl.sensors.StateSensor_4_0_5.State();
    }

    public class GetStateResult {
      public Com.Raritan.Idl.sensors.StateSensor_4_0_5.State _ret_;
    }

    public GetStateResult getState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getState", _parameters);
      var _ret = new GetStateResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.StateSensor_4_0_5.State.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getState", _parameters,
        _result => {
          try {
            var _ret = new GetStateResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.StateSensor_4_0_5.State.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
