# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Sensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.sensors


# interface
class Sensor(Interface):
    idlType = "sensors.Sensor:4.0.5"

    ERR_NOT_SUPPORTED = 1

    NUMERIC = 0

    DISCRETE_ON_OFF = 1

    DISCRETE_MULTI = 2

    # enumeration
    class OnOffState(Enumeration):
        idlType = "sensors.Sensor_4_0_5.OnOffState:1.0.0"
        values = ["OFF", "ON"]

    OnOffState.OFF = OnOffState(0)
    OnOffState.ON = OnOffState(1)

    # enumeration
    class OpenClosedState(Enumeration):
        idlType = "sensors.Sensor_4_0_5.OpenClosedState:1.0.0"
        values = ["OPEN", "CLOSED"]

    OpenClosedState.OPEN = OpenClosedState(0)
    OpenClosedState.CLOSED = OpenClosedState(1)

    # enumeration
    class NormalAlarmedState(Enumeration):
        idlType = "sensors.Sensor_4_0_5.NormalAlarmedState:1.0.0"
        values = ["NORMAL", "ALARMED"]

    NormalAlarmedState.NORMAL = NormalAlarmedState(0)
    NormalAlarmedState.ALARMED = NormalAlarmedState(1)

    # enumeration
    class OkFaultState(Enumeration):
        idlType = "sensors.Sensor_4_0_5.OkFaultState:1.0.0"
        values = ["OK", "FAULT"]

    OkFaultState.OK = OkFaultState(0)
    OkFaultState.FAULT = OkFaultState(1)

    UNSPECIFIED = 0

    VOLTAGE = 1

    CURRENT = 2

    UNBALANCE_CURRENT = 3

    POWER = 4

    POWER_FACTOR = 5

    ENERGY = 6

    FREQUENCY = 7

    TEMPERATURE = 8

    HUMIDITY = 9

    AIR_FLOW = 10

    AIR_PRESSURE = 11

    CONTACT_CLOSURE = 12

    ON_OFF_SENSOR = 13

    TRIP_SENSOR = 14

    VIBRATION = 15

    WATER_LEAK = 16

    SMOKE_DETECTOR = 17

    TOTAL_HARMONIC_DISTORTION = 18

    MASS = 19

    ELECTRICAL_RESISTANCE = 20

    FLUX = 21

    LUMINOUS_INTENSITY = 22

    ACCELERATION = 23

    MAGNETIC_FLUX_DENSITY = 24

    ELECTRIC_FIELD_STRENGTH = 25

    MAGNETIC_FIELD_STRENGTH = 26

    ANGLE = 27

    SELECTION = 28

    FAULT_STATE = 29

    POWER_QUALITY = 30

    ROTATIONAL_SPEED = 31

    LUMINOUS_ENERGY = 32

    LUMINOUS_FLUX = 33

    ILLUMINANCE = 34

    LUMINOUS_EMITTANCE = 35

    MOTION = 36

    OCCUPANCY = 37

    TAMPER = 38

    DRY_CONTACT = 39

    POWERED_DRY_CONTACT = 40

    ABSOLUTE_HUMIDITY = 41

    DOOR_STATE = 42

    DOOR_LOCK_STATE = 43

    DOOR_HANDLE_LOCK = 44

    CREST_FACTOR = 45

    DISTANCE = 46

    LENGTH = 47

    UNBALANCE_VOLTAGE = 48

    PARTICLE_DENSITY = 49

    NONE = 0

    VOLT = 1

    AMPERE = 2

    WATT = 3

    VOLT_AMP = 4

    WATT_HOUR = 5

    VOLT_AMP_HOUR = 6

    DEGREE_CELSIUS = 7

    HZ = 8

    PERCENT = 9

    METER_PER_SEC = 10

    PASCAL = 11

    G = 12

    RPM = 13

    METER = 14

    HOUR = 15

    MINUTE = 16

    SECOND = 17

    VOLT_AMP_REACTIVE = 18

    VOLT_AMP_REACTIVE_HOUR = 19

    GRAM = 20

    OHM = 21

    LITERS_PER_HOUR = 22

    CANDELA = 23

    METER_PER_SQUARE_SEC = 24

    METER_PER_SQARE_SEC = 24

    TESLA = 25

    VOLT_PER_METER = 26

    VOLT_PER_AMPERE = 27

    DEGREE = 28

    DEGREE_FAHRENHEIT = 29

    KELVIN = 30

    JOULE = 31

    COULOMB = 32

    NIT = 33

    LUMEN = 34

    LUMEN_SECOND = 35

    LUX = 36

    PSI = 37

    NEWTON = 38

    FOOT = 39

    FOOT_PER_SEC = 40

    CUBIC_METER = 41

    RADIANT = 42

    STERADIANT = 43

    HENRY = 44

    FARAD = 45

    MOL = 46

    BECQUEREL = 47

    GRAY = 48

    SIEVERT = 49

    G_PER_CUBIC_METER = 50

    UG_PER_CUBIC_METER = 51

    # structure
    class TypeSpec(Structure):
        idlType = "sensors.Sensor_4_0_5.TypeSpec:1.0.0"
        elements = ["readingtype", "type", "unit"]

        def __init__(self, readingtype, type, unit):
            typecheck.is_int(readingtype, AssertionError)
            typecheck.is_int(type, AssertionError)
            typecheck.is_int(unit, AssertionError)

            self.readingtype = readingtype
            self.type = type
            self.unit = unit

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                readingtype = json['readingtype'],
                type = json['type'],
                unit = json['unit'],
            )
            return obj

        def encode(self):
            json = {}
            json['readingtype'] = self.readingtype
            json['type'] = self.type
            json['unit'] = self.unit
            return json

    # value object
    class TypeSpecChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.Sensor_4_0_5.TypeSpecChangedEvent:1.0.0"

        def __init__(self, oldTypeSpec, newTypeSpec, source):
            super(raritan.rpc.sensors.Sensor.TypeSpecChangedEvent, self).__init__(source)
            typecheck.is_struct(oldTypeSpec, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
            typecheck.is_struct(newTypeSpec, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)

            self.oldTypeSpec = oldTypeSpec
            self.newTypeSpec = newTypeSpec

        def encode(self):
            json = super(raritan.rpc.sensors.Sensor.TypeSpecChangedEvent, self).encode()
            json['oldTypeSpec'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.oldTypeSpec)
            json['newTypeSpec'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.newTypeSpec)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldTypeSpec = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['oldTypeSpec'], agent),
                newTypeSpec = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['newTypeSpec'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldTypeSpec", "newTypeSpec"]
            elements = elements + super(raritan.rpc.sensors.Sensor.TypeSpecChangedEvent, self).listElements()
            return elements

    class _getTypeSpec(Interface.Method):
        name = 'getTypeSpec'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.Sensor.TypeSpec.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.Sensor.TypeSpec, DecodeException)
            return _ret_

    class _isTypeChangeAllowed(Interface.Method):
        name = 'isTypeChangeAllowed'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setType(Interface.Method):
        name = 'setType'

        @staticmethod
        def encode(type, unit):
            typecheck.is_int(type, AssertionError)
            typecheck.is_int(unit, AssertionError)
            args = {}
            args['type'] = type
            args['unit'] = unit
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Sensor, self).__init__(target, agent)
        self.getTypeSpec = Sensor._getTypeSpec(self)
        self.isTypeChangeAllowed = Sensor._isTypeChangeAllowed(self)
        self.setType = Sensor._setType(self)

#
# Section generated by IdlC from "NumericSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.sensors


# interface
class NumericSensor(Sensor):
    idlType = "sensors.NumericSensor:4.0.6"

    THRESHOLD_OUT_OF_RANGE = 1

    THRESHOLD_INVALID = 2

    THRESHOLD_NOT_SUPPORTED = 3

    # structure
    class Range(Structure):
        idlType = "sensors.NumericSensor_4_0_6.Range:1.0.0"
        elements = ["lower", "upper"]

        def __init__(self, lower, upper):
            typecheck.is_double(lower, AssertionError)
            typecheck.is_double(upper, AssertionError)

            self.lower = lower
            self.upper = upper

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                lower = json['lower'],
                upper = json['upper'],
            )
            return obj

        def encode(self):
            json = {}
            json['lower'] = self.lower
            json['upper'] = self.upper
            return json

    # structure
    class ThresholdCapabilities(Structure):
        idlType = "sensors.NumericSensor_4_0_6.ThresholdCapabilities:1.0.0"
        elements = ["hasUpperCritical", "hasUpperWarning", "hasLowerWarning", "hasLowerCritical"]

        def __init__(self, hasUpperCritical, hasUpperWarning, hasLowerWarning, hasLowerCritical):
            typecheck.is_bool(hasUpperCritical, AssertionError)
            typecheck.is_bool(hasUpperWarning, AssertionError)
            typecheck.is_bool(hasLowerWarning, AssertionError)
            typecheck.is_bool(hasLowerCritical, AssertionError)

            self.hasUpperCritical = hasUpperCritical
            self.hasUpperWarning = hasUpperWarning
            self.hasLowerWarning = hasLowerWarning
            self.hasLowerCritical = hasLowerCritical

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                hasUpperCritical = json['hasUpperCritical'],
                hasUpperWarning = json['hasUpperWarning'],
                hasLowerWarning = json['hasLowerWarning'],
                hasLowerCritical = json['hasLowerCritical'],
            )
            return obj

        def encode(self):
            json = {}
            json['hasUpperCritical'] = self.hasUpperCritical
            json['hasUpperWarning'] = self.hasUpperWarning
            json['hasLowerWarning'] = self.hasLowerWarning
            json['hasLowerCritical'] = self.hasLowerCritical
            return json

    # structure
    class MetaData(Structure):
        idlType = "sensors.NumericSensor_4_0_6.MetaData:1.0.0"
        elements = ["type", "decdigits", "accuracy", "resolution", "tolerance", "noiseThreshold", "range", "thresholdCaps"]

        def __init__(self, type, decdigits, accuracy, resolution, tolerance, noiseThreshold, range, thresholdCaps):
            typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
            typecheck.is_int(decdigits, AssertionError)
            typecheck.is_float(accuracy, AssertionError)
            typecheck.is_float(resolution, AssertionError)
            typecheck.is_float(tolerance, AssertionError)
            typecheck.is_float(noiseThreshold, AssertionError)
            typecheck.is_struct(range, raritan.rpc.sensors.NumericSensor.Range, AssertionError)
            typecheck.is_struct(thresholdCaps, raritan.rpc.sensors.NumericSensor.ThresholdCapabilities, AssertionError)

            self.type = type
            self.decdigits = decdigits
            self.accuracy = accuracy
            self.resolution = resolution
            self.tolerance = tolerance
            self.noiseThreshold = noiseThreshold
            self.range = range
            self.thresholdCaps = thresholdCaps

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                decdigits = json['decdigits'],
                accuracy = json['accuracy'],
                resolution = json['resolution'],
                tolerance = json['tolerance'],
                noiseThreshold = json['noiseThreshold'],
                range = raritan.rpc.sensors.NumericSensor.Range.decode(json['range'], agent),
                thresholdCaps = raritan.rpc.sensors.NumericSensor.ThresholdCapabilities.decode(json['thresholdCaps'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
            json['decdigits'] = self.decdigits
            json['accuracy'] = self.accuracy
            json['resolution'] = self.resolution
            json['tolerance'] = self.tolerance
            json['noiseThreshold'] = self.noiseThreshold
            json['range'] = raritan.rpc.sensors.NumericSensor.Range.encode(self.range)
            json['thresholdCaps'] = raritan.rpc.sensors.NumericSensor.ThresholdCapabilities.encode(self.thresholdCaps)
            return json

    # structure
    class Thresholds(Structure):
        idlType = "sensors.NumericSensor_4_0_6.Thresholds:1.0.0"
        elements = ["upperCriticalActive", "upperCritical", "upperWarningActive", "upperWarning", "lowerWarningActive", "lowerWarning", "lowerCriticalActive", "lowerCritical", "assertionTimeout", "deassertionHysteresis"]

        def __init__(self, upperCriticalActive, upperCritical, upperWarningActive, upperWarning, lowerWarningActive, lowerWarning, lowerCriticalActive, lowerCritical, assertionTimeout, deassertionHysteresis):
            typecheck.is_bool(upperCriticalActive, AssertionError)
            typecheck.is_double(upperCritical, AssertionError)
            typecheck.is_bool(upperWarningActive, AssertionError)
            typecheck.is_double(upperWarning, AssertionError)
            typecheck.is_bool(lowerWarningActive, AssertionError)
            typecheck.is_double(lowerWarning, AssertionError)
            typecheck.is_bool(lowerCriticalActive, AssertionError)
            typecheck.is_double(lowerCritical, AssertionError)
            typecheck.is_int(assertionTimeout, AssertionError)
            typecheck.is_float(deassertionHysteresis, AssertionError)

            self.upperCriticalActive = upperCriticalActive
            self.upperCritical = upperCritical
            self.upperWarningActive = upperWarningActive
            self.upperWarning = upperWarning
            self.lowerWarningActive = lowerWarningActive
            self.lowerWarning = lowerWarning
            self.lowerCriticalActive = lowerCriticalActive
            self.lowerCritical = lowerCritical
            self.assertionTimeout = assertionTimeout
            self.deassertionHysteresis = deassertionHysteresis

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                upperCriticalActive = json['upperCriticalActive'],
                upperCritical = json['upperCritical'],
                upperWarningActive = json['upperWarningActive'],
                upperWarning = json['upperWarning'],
                lowerWarningActive = json['lowerWarningActive'],
                lowerWarning = json['lowerWarning'],
                lowerCriticalActive = json['lowerCriticalActive'],
                lowerCritical = json['lowerCritical'],
                assertionTimeout = json['assertionTimeout'],
                deassertionHysteresis = json['deassertionHysteresis'],
            )
            return obj

        def encode(self):
            json = {}
            json['upperCriticalActive'] = self.upperCriticalActive
            json['upperCritical'] = self.upperCritical
            json['upperWarningActive'] = self.upperWarningActive
            json['upperWarning'] = self.upperWarning
            json['lowerWarningActive'] = self.lowerWarningActive
            json['lowerWarning'] = self.lowerWarning
            json['lowerCriticalActive'] = self.lowerCriticalActive
            json['lowerCritical'] = self.lowerCritical
            json['assertionTimeout'] = self.assertionTimeout
            json['deassertionHysteresis'] = self.deassertionHysteresis
            return json

    # structure
    class Reading(Structure):
        idlType = "sensors.NumericSensor_4_0_6.Reading:1.0.0"
        elements = ["timestamp", "available", "status", "valid", "value"]

        def __init__(self, timestamp, available, status, valid, value):
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_bool(available, AssertionError)
            typecheck.is_struct(status, raritan.rpc.sensors.NumericSensor.Reading.Status, AssertionError)
            typecheck.is_bool(valid, AssertionError)
            typecheck.is_double(value, AssertionError)

            self.timestamp = timestamp
            self.available = available
            self.status = status
            self.valid = valid
            self.value = value

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                available = json['available'],
                status = raritan.rpc.sensors.NumericSensor.Reading.Status.decode(json['status'], agent),
                valid = json['valid'],
                value = json['value'],
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['available'] = self.available
            json['status'] = raritan.rpc.sensors.NumericSensor.Reading.Status.encode(self.status)
            json['valid'] = self.valid
            json['value'] = self.value
            return json

        # structure
        class Status(Structure):
            idlType = "sensors.NumericSensor_4_0_6.Reading.Status:1.0.0"
            elements = ["aboveUpperCritical", "aboveUpperWarning", "belowLowerWarning", "belowLowerCritical"]

            def __init__(self, aboveUpperCritical, aboveUpperWarning, belowLowerWarning, belowLowerCritical):
                typecheck.is_bool(aboveUpperCritical, AssertionError)
                typecheck.is_bool(aboveUpperWarning, AssertionError)
                typecheck.is_bool(belowLowerWarning, AssertionError)
                typecheck.is_bool(belowLowerCritical, AssertionError)

                self.aboveUpperCritical = aboveUpperCritical
                self.aboveUpperWarning = aboveUpperWarning
                self.belowLowerWarning = belowLowerWarning
                self.belowLowerCritical = belowLowerCritical

            @classmethod
            def decode(cls, json, agent):
                obj = cls(
                    aboveUpperCritical = json['aboveUpperCritical'],
                    aboveUpperWarning = json['aboveUpperWarning'],
                    belowLowerWarning = json['belowLowerWarning'],
                    belowLowerCritical = json['belowLowerCritical'],
                )
                return obj

            def encode(self):
                json = {}
                json['aboveUpperCritical'] = self.aboveUpperCritical
                json['aboveUpperWarning'] = self.aboveUpperWarning
                json['belowLowerWarning'] = self.belowLowerWarning
                json['belowLowerCritical'] = self.belowLowerCritical
                return json

    # structure
    class MinMax(Structure):
        idlType = "sensors.NumericSensor_4_0_6.MinMax:1.0.0"
        elements = ["minReading", "minReadingTimestamp", "maxReading", "maxReadingTimestamp", "valid", "observedSince"]

        def __init__(self, minReading, minReadingTimestamp, maxReading, maxReadingTimestamp, valid, observedSince):
            typecheck.is_double(minReading, AssertionError)
            typecheck.is_time(minReadingTimestamp, AssertionError)
            typecheck.is_double(maxReading, AssertionError)
            typecheck.is_time(maxReadingTimestamp, AssertionError)
            typecheck.is_bool(valid, AssertionError)
            typecheck.is_time(observedSince, AssertionError)

            self.minReading = minReading
            self.minReadingTimestamp = minReadingTimestamp
            self.maxReading = maxReading
            self.maxReadingTimestamp = maxReadingTimestamp
            self.valid = valid
            self.observedSince = observedSince

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                minReading = json['minReading'],
                minReadingTimestamp = raritan.rpc.Time.decode(json['minReadingTimestamp']),
                maxReading = json['maxReading'],
                maxReadingTimestamp = raritan.rpc.Time.decode(json['maxReadingTimestamp']),
                valid = json['valid'],
                observedSince = raritan.rpc.Time.decode(json['observedSince']),
            )
            return obj

        def encode(self):
            json = {}
            json['minReading'] = self.minReading
            json['minReadingTimestamp'] = raritan.rpc.Time.encode(self.minReadingTimestamp)
            json['maxReading'] = self.maxReading
            json['maxReadingTimestamp'] = raritan.rpc.Time.encode(self.maxReadingTimestamp)
            json['valid'] = self.valid
            json['observedSince'] = raritan.rpc.Time.encode(self.observedSince)
            return json

    # value object
    class ReadingChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.NumericSensor_4_0_6.ReadingChangedEvent:1.0.0"

        def __init__(self, newReading, source):
            super(raritan.rpc.sensors.NumericSensor.ReadingChangedEvent, self).__init__(source)
            typecheck.is_struct(newReading, raritan.rpc.sensors.NumericSensor.Reading, AssertionError)

            self.newReading = newReading

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.ReadingChangedEvent, self).encode()
            json['newReading'] = raritan.rpc.sensors.NumericSensor.Reading.encode(self.newReading)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newReading = raritan.rpc.sensors.NumericSensor.Reading.decode(json['newReading'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newReading"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.ReadingChangedEvent, self).listElements()
            return elements

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.NumericSensor_4_0_6.StateChangedEvent:1.0.0"

        def __init__(self, oldReading, newReading, source):
            super(raritan.rpc.sensors.NumericSensor.StateChangedEvent, self).__init__(source)
            typecheck.is_struct(oldReading, raritan.rpc.sensors.NumericSensor.Reading, AssertionError)
            typecheck.is_struct(newReading, raritan.rpc.sensors.NumericSensor.Reading, AssertionError)

            self.oldReading = oldReading
            self.newReading = newReading

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.StateChangedEvent, self).encode()
            json['oldReading'] = raritan.rpc.sensors.NumericSensor.Reading.encode(self.oldReading)
            json['newReading'] = raritan.rpc.sensors.NumericSensor.Reading.encode(self.newReading)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldReading = raritan.rpc.sensors.NumericSensor.Reading.decode(json['oldReading'], agent),
                newReading = raritan.rpc.sensors.NumericSensor.Reading.decode(json['newReading'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldReading", "newReading"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.StateChangedEvent, self).listElements()
            return elements

    # value object
    class MetaDataChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.NumericSensor_4_0_6.MetaDataChangedEvent:1.0.0"

        def __init__(self, oldMetaData, newMetaData, source):
            super(raritan.rpc.sensors.NumericSensor.MetaDataChangedEvent, self).__init__(source)
            typecheck.is_struct(oldMetaData, raritan.rpc.sensors.NumericSensor.MetaData, AssertionError)
            typecheck.is_struct(newMetaData, raritan.rpc.sensors.NumericSensor.MetaData, AssertionError)

            self.oldMetaData = oldMetaData
            self.newMetaData = newMetaData

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.MetaDataChangedEvent, self).encode()
            json['oldMetaData'] = raritan.rpc.sensors.NumericSensor.MetaData.encode(self.oldMetaData)
            json['newMetaData'] = raritan.rpc.sensors.NumericSensor.MetaData.encode(self.newMetaData)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldMetaData = raritan.rpc.sensors.NumericSensor.MetaData.decode(json['oldMetaData'], agent),
                newMetaData = raritan.rpc.sensors.NumericSensor.MetaData.decode(json['newMetaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldMetaData", "newMetaData"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.MetaDataChangedEvent, self).listElements()
            return elements

    # value object
    class DefaultThresholdsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.NumericSensor_4_0_6.DefaultThresholdsChangedEvent:1.0.0"

        def __init__(self, oldDefaultThresholds, newDefaultThresholds, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.NumericSensor.DefaultThresholdsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldDefaultThresholds, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)
            typecheck.is_struct(newDefaultThresholds, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)

            self.oldDefaultThresholds = oldDefaultThresholds
            self.newDefaultThresholds = newDefaultThresholds

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.DefaultThresholdsChangedEvent, self).encode()
            json['oldDefaultThresholds'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(self.oldDefaultThresholds)
            json['newDefaultThresholds'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(self.newDefaultThresholds)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldDefaultThresholds = raritan.rpc.sensors.NumericSensor.Thresholds.decode(json['oldDefaultThresholds'], agent),
                newDefaultThresholds = raritan.rpc.sensors.NumericSensor.Thresholds.decode(json['newDefaultThresholds'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldDefaultThresholds", "newDefaultThresholds"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.DefaultThresholdsChangedEvent, self).listElements()
            return elements

    # value object
    class ThresholdsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.NumericSensor_4_0_6.ThresholdsChangedEvent:1.0.0"

        def __init__(self, oldThresholds, newThresholds, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.NumericSensor.ThresholdsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldThresholds, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)
            typecheck.is_struct(newThresholds, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)

            self.oldThresholds = oldThresholds
            self.newThresholds = newThresholds

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.ThresholdsChangedEvent, self).encode()
            json['oldThresholds'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(self.oldThresholds)
            json['newThresholds'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(self.newThresholds)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldThresholds = raritan.rpc.sensors.NumericSensor.Thresholds.decode(json['oldThresholds'], agent),
                newThresholds = raritan.rpc.sensors.NumericSensor.Thresholds.decode(json['newThresholds'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldThresholds", "newThresholds"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.ThresholdsChangedEvent, self).listElements()
            return elements

    # value object
    class MinMaxChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.NumericSensor_4_0_6.MinMaxChangedEvent:1.0.0"

        def __init__(self, newMinMax, source):
            super(raritan.rpc.sensors.NumericSensor.MinMaxChangedEvent, self).__init__(source)
            typecheck.is_struct(newMinMax, raritan.rpc.sensors.NumericSensor.MinMax, AssertionError)

            self.newMinMax = newMinMax

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.MinMaxChangedEvent, self).encode()
            json['newMinMax'] = raritan.rpc.sensors.NumericSensor.MinMax.encode(self.newMinMax)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newMinMax = raritan.rpc.sensors.NumericSensor.MinMax.decode(json['newMinMax'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newMinMax"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.MinMaxChangedEvent, self).listElements()
            return elements

    # value object
    class MinMaxResetEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.NumericSensor_4_0_6.MinMaxResetEvent:1.0.0"

        def __init__(self, oldMinMax, newMinMax, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.NumericSensor.MinMaxResetEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldMinMax, raritan.rpc.sensors.NumericSensor.MinMax, AssertionError)
            typecheck.is_struct(newMinMax, raritan.rpc.sensors.NumericSensor.MinMax, AssertionError)

            self.oldMinMax = oldMinMax
            self.newMinMax = newMinMax

        def encode(self):
            json = super(raritan.rpc.sensors.NumericSensor.MinMaxResetEvent, self).encode()
            json['oldMinMax'] = raritan.rpc.sensors.NumericSensor.MinMax.encode(self.oldMinMax)
            json['newMinMax'] = raritan.rpc.sensors.NumericSensor.MinMax.encode(self.newMinMax)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldMinMax = raritan.rpc.sensors.NumericSensor.MinMax.decode(json['oldMinMax'], agent),
                newMinMax = raritan.rpc.sensors.NumericSensor.MinMax.decode(json['newMinMax'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldMinMax", "newMinMax"]
            elements = elements + super(raritan.rpc.sensors.NumericSensor.MinMaxResetEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.NumericSensor.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.NumericSensor.MetaData, DecodeException)
            return _ret_

    class _getDefaultThresholds(Interface.Method):
        name = 'getDefaultThresholds'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.NumericSensor.Thresholds.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.NumericSensor.Thresholds, DecodeException)
            return _ret_

    class _getThresholds(Interface.Method):
        name = 'getThresholds'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.NumericSensor.Thresholds.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.NumericSensor.Thresholds, DecodeException)
            return _ret_

    class _setThresholds(Interface.Method):
        name = 'setThresholds'

        @staticmethod
        def encode(thresh):
            typecheck.is_struct(thresh, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)
            args = {}
            args['thresh'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(thresh)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getReading(Interface.Method):
        name = 'getReading'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.NumericSensor.Reading.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.NumericSensor.Reading, DecodeException)
            return _ret_

    class _getMinMax(Interface.Method):
        name = 'getMinMax'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.NumericSensor.MinMax.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.NumericSensor.MinMax, DecodeException)
            return _ret_

    class _resetMinMax(Interface.Method):
        name = 'resetMinMax'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(NumericSensor, self).__init__(target, agent)
        self.getMetaData = NumericSensor._getMetaData(self)
        self.getDefaultThresholds = NumericSensor._getDefaultThresholds(self)
        self.getThresholds = NumericSensor._getThresholds(self)
        self.setThresholds = NumericSensor._setThresholds(self)
        self.getReading = NumericSensor._getReading(self)
        self.getMinMax = NumericSensor._getMinMax(self)
        self.resetMinMax = NumericSensor._resetMinMax(self)

#
# Section generated by IdlC from "AccumulatingNumericSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.sensors


# interface
class AccumulatingNumericSensor(NumericSensor):
    idlType = "sensors.AccumulatingNumericSensor:2.0.6"

    # value object
    class ResetEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.AccumulatingNumericSensor_2_0_6.ResetEvent:1.0.0"

        def __init__(self, oldReading, newReading, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.AccumulatingNumericSensor.ResetEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldReading, raritan.rpc.sensors.NumericSensor.Reading, AssertionError)
            typecheck.is_struct(newReading, raritan.rpc.sensors.NumericSensor.Reading, AssertionError)

            self.oldReading = oldReading
            self.newReading = newReading

        def encode(self):
            json = super(raritan.rpc.sensors.AccumulatingNumericSensor.ResetEvent, self).encode()
            json['oldReading'] = raritan.rpc.sensors.NumericSensor.Reading.encode(self.oldReading)
            json['newReading'] = raritan.rpc.sensors.NumericSensor.Reading.encode(self.newReading)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldReading = raritan.rpc.sensors.NumericSensor.Reading.decode(json['oldReading'], agent),
                newReading = raritan.rpc.sensors.NumericSensor.Reading.decode(json['newReading'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldReading", "newReading"]
            elements = elements + super(raritan.rpc.sensors.AccumulatingNumericSensor.ResetEvent, self).listElements()
            return elements

    class _resetValue(Interface.Method):
        name = 'resetValue'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(AccumulatingNumericSensor, self).__init__(target, agent)
        self.resetValue = AccumulatingNumericSensor._resetValue(self)

#
# Section generated by IdlC from "AlertedSensorManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.sensors


# interface
class AlertedSensorManager(Interface):
    idlType = "sensors.AlertedSensorManager:1.0.3"

    # enumeration
    class AlertState(Enumeration):
        idlType = "sensors.AlertedSensorManager_1_0_3.AlertState:1.0.0"
        values = ["UNAVAILABLE", "NORMAL", "CRITICAL", "WARNED"]

    AlertState.UNAVAILABLE = AlertState(0)
    AlertState.NORMAL = AlertState(1)
    AlertState.CRITICAL = AlertState(2)
    AlertState.WARNED = AlertState(3)

    # structure
    class SensorCounts(Structure):
        idlType = "sensors.AlertedSensorManager_1_0_3.SensorCounts:1.0.0"
        elements = ["total", "unavailable", "critical", "warned"]

        def __init__(self, total, unavailable, critical, warned):
            typecheck.is_int(total, AssertionError)
            typecheck.is_int(unavailable, AssertionError)
            typecheck.is_int(critical, AssertionError)
            typecheck.is_int(warned, AssertionError)

            self.total = total
            self.unavailable = unavailable
            self.critical = critical
            self.warned = warned

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                total = json['total'],
                unavailable = json['unavailable'],
                critical = json['critical'],
                warned = json['warned'],
            )
            return obj

        def encode(self):
            json = {}
            json['total'] = self.total
            json['unavailable'] = self.unavailable
            json['critical'] = self.critical
            json['warned'] = self.warned
            return json

    # structure
    class SensorData(Structure):
        idlType = "sensors.AlertedSensorManager_1_0_3.SensorData:1.0.0"
        elements = ["sensor", "parent", "alertState"]

        def __init__(self, sensor, parent, alertState):
            typecheck.is_interface(sensor, raritan.rpc.sensors.Sensor, AssertionError)
            typecheck.is_remote_obj(parent, AssertionError)
            typecheck.is_enum(alertState, raritan.rpc.sensors.AlertedSensorManager.AlertState, AssertionError)

            self.sensor = sensor
            self.parent = parent
            self.alertState = alertState

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sensor = Interface.decode(json['sensor'], agent),
                parent = Interface.decode(json['parent'], agent),
                alertState = raritan.rpc.sensors.AlertedSensorManager.AlertState.decode(json['alertState']),
            )
            return obj

        def encode(self):
            json = {}
            json['sensor'] = Interface.encode(self.sensor)
            json['parent'] = Interface.encode(self.parent)
            json['alertState'] = raritan.rpc.sensors.AlertedSensorManager.AlertState.encode(self.alertState)
            return json

    # value object
    class MonitoredSensorsChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.AlertedSensorManager_1_0_3.MonitoredSensorsChangedEvent:1.0.0"

        def __init__(self, counts, source):
            super(raritan.rpc.sensors.AlertedSensorManager.MonitoredSensorsChangedEvent, self).__init__(source)
            typecheck.is_struct(counts, raritan.rpc.sensors.AlertedSensorManager.SensorCounts, AssertionError)

            self.counts = counts

        def encode(self):
            json = super(raritan.rpc.sensors.AlertedSensorManager.MonitoredSensorsChangedEvent, self).encode()
            json['counts'] = raritan.rpc.sensors.AlertedSensorManager.SensorCounts.encode(self.counts)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                counts = raritan.rpc.sensors.AlertedSensorManager.SensorCounts.decode(json['counts'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["counts"]
            elements = elements + super(raritan.rpc.sensors.AlertedSensorManager.MonitoredSensorsChangedEvent, self).listElements()
            return elements

    # value object
    class AlertedSensorsChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.AlertedSensorManager_1_0_3.AlertedSensorsChangedEvent:1.0.0"

        def __init__(self, counts, changedSensors, removedSensors, source):
            super(raritan.rpc.sensors.AlertedSensorManager.AlertedSensorsChangedEvent, self).__init__(source)
            typecheck.is_struct(counts, raritan.rpc.sensors.AlertedSensorManager.SensorCounts, AssertionError)
            for x0 in changedSensors:
                typecheck.is_struct(x0, raritan.rpc.sensors.AlertedSensorManager.SensorData, AssertionError)
            for x0 in removedSensors:
                typecheck.is_interface(x0, raritan.rpc.sensors.Sensor, AssertionError)

            self.counts = counts
            self.changedSensors = changedSensors
            self.removedSensors = removedSensors

        def encode(self):
            json = super(raritan.rpc.sensors.AlertedSensorManager.AlertedSensorsChangedEvent, self).encode()
            json['counts'] = raritan.rpc.sensors.AlertedSensorManager.SensorCounts.encode(self.counts)
            json['changedSensors'] = [raritan.rpc.sensors.AlertedSensorManager.SensorData.encode(x0) for x0 in self.changedSensors]
            json['removedSensors'] = [Interface.encode(x0) for x0 in self.removedSensors]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                counts = raritan.rpc.sensors.AlertedSensorManager.SensorCounts.decode(json['counts'], agent),
                changedSensors = [raritan.rpc.sensors.AlertedSensorManager.SensorData.decode(x0, agent) for x0 in json['changedSensors']],
                removedSensors = [Interface.decode(x0, agent) for x0 in json['removedSensors']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["counts", "changedSensors", "removedSensors"]
            elements = elements + super(raritan.rpc.sensors.AlertedSensorManager.AlertedSensorsChangedEvent, self).listElements()
            return elements

    class _getSensorCounts(Interface.Method):
        name = 'getSensorCounts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.AlertedSensorManager.SensorCounts.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.AlertedSensorManager.SensorCounts, DecodeException)
            return _ret_

    class _getAllSensors(Interface.Method):
        name = 'getAllSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.sensors.AlertedSensorManager.SensorData.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.sensors.AlertedSensorManager.SensorData, DecodeException)
            return _ret_

    class _getAlertedSensors(Interface.Method):
        name = 'getAlertedSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.sensors.AlertedSensorManager.SensorData.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.sensors.AlertedSensorManager.SensorData, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(AlertedSensorManager, self).__init__(target, agent)
        self.getSensorCounts = AlertedSensorManager._getSensorCounts(self)
        self.getAllSensors = AlertedSensorManager._getAllSensors(self)
        self.getAlertedSensors = AlertedSensorManager._getAlertedSensors(self)

#
# Section generated by IdlC from "StateSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.sensors


# interface
class StateSensor(Sensor):
    idlType = "sensors.StateSensor:4.0.5"

    # structure
    class State(Structure):
        idlType = "sensors.StateSensor_4_0_5.State:1.0.0"
        elements = ["timestamp", "available", "value"]

        def __init__(self, timestamp, available, value):
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_bool(available, AssertionError)
            typecheck.is_int(value, AssertionError)

            self.timestamp = timestamp
            self.available = available
            self.value = value

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                available = json['available'],
                value = json['value'],
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['available'] = self.available
            json['value'] = self.value
            return json

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.StateSensor_4_0_5.StateChangedEvent:1.0.0"

        def __init__(self, oldState, newState, source):
            super(raritan.rpc.sensors.StateSensor.StateChangedEvent, self).__init__(source)
            typecheck.is_struct(oldState, raritan.rpc.sensors.StateSensor.State, AssertionError)
            typecheck.is_struct(newState, raritan.rpc.sensors.StateSensor.State, AssertionError)

            self.oldState = oldState
            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.sensors.StateSensor.StateChangedEvent, self).encode()
            json['oldState'] = raritan.rpc.sensors.StateSensor.State.encode(self.oldState)
            json['newState'] = raritan.rpc.sensors.StateSensor.State.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldState = raritan.rpc.sensors.StateSensor.State.decode(json['oldState'], agent),
                newState = raritan.rpc.sensors.StateSensor.State.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldState", "newState"]
            elements = elements + super(raritan.rpc.sensors.StateSensor.StateChangedEvent, self).listElements()
            return elements

    class _getState(Interface.Method):
        name = 'getState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.StateSensor.State.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.StateSensor.State, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(StateSensor, self).__init__(target, agent)
        self.getState = StateSensor._getState(self)

#
# Section generated by IdlC from "SensorLogger.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# interface
class Logger(Interface):
    idlType = "sensors.Logger:3.1.1"

    # structure
    class Info(Structure):
        idlType = "sensors.Logger_3_1_1.Info:1.0.0"
        elements = ["samplePeriod", "maxTotalRecords", "effectiveCapacity", "oldestRecId", "newestRecId"]

        def __init__(self, samplePeriod, maxTotalRecords, effectiveCapacity, oldestRecId, newestRecId):
            typecheck.is_int(samplePeriod, AssertionError)
            typecheck.is_int(maxTotalRecords, AssertionError)
            typecheck.is_int(effectiveCapacity, AssertionError)
            typecheck.is_int(oldestRecId, AssertionError)
            typecheck.is_int(newestRecId, AssertionError)

            self.samplePeriod = samplePeriod
            self.maxTotalRecords = maxTotalRecords
            self.effectiveCapacity = effectiveCapacity
            self.oldestRecId = oldestRecId
            self.newestRecId = newestRecId

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                samplePeriod = json['samplePeriod'],
                maxTotalRecords = json['maxTotalRecords'],
                effectiveCapacity = json['effectiveCapacity'],
                oldestRecId = json['oldestRecId'],
                newestRecId = json['newestRecId'],
            )
            return obj

        def encode(self):
            json = {}
            json['samplePeriod'] = self.samplePeriod
            json['maxTotalRecords'] = self.maxTotalRecords
            json['effectiveCapacity'] = self.effectiveCapacity
            json['oldestRecId'] = self.oldestRecId
            json['newestRecId'] = self.newestRecId
            return json

    # structure
    class Settings(Structure):
        idlType = "sensors.Logger_3_1_1.Settings:1.0.0"
        elements = ["isEnabled", "samplesPerRecord", "logCapacity", "backupEnabled"]

        def __init__(self, isEnabled, samplesPerRecord, logCapacity, backupEnabled):
            typecheck.is_bool(isEnabled, AssertionError)
            typecheck.is_int(samplesPerRecord, AssertionError)
            typecheck.is_int(logCapacity, AssertionError)
            typecheck.is_bool(backupEnabled, AssertionError)

            self.isEnabled = isEnabled
            self.samplesPerRecord = samplesPerRecord
            self.logCapacity = logCapacity
            self.backupEnabled = backupEnabled

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                isEnabled = json['isEnabled'],
                samplesPerRecord = json['samplesPerRecord'],
                logCapacity = json['logCapacity'],
                backupEnabled = json['backupEnabled'],
            )
            return obj

        def encode(self):
            json = {}
            json['isEnabled'] = self.isEnabled
            json['samplesPerRecord'] = self.samplesPerRecord
            json['logCapacity'] = self.logCapacity
            json['backupEnabled'] = self.backupEnabled
            return json

    # structure
    class SensorSet(Structure):
        idlType = "sensors.Logger_3_1_1.SensorSet:1.0.0"
        elements = ["sensors", "slots"]

        def __init__(self, sensors, slots):
            for x0 in sensors:
                typecheck.is_interface(x0, raritan.rpc.sensors.Sensor, AssertionError)
            for x0 in slots:
                typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, AssertionError)

            self.sensors = sensors
            self.slots = slots

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sensors = [Interface.decode(x0, agent) for x0 in json['sensors']],
                slots = [Interface.decode(x0, agent) for x0 in json['slots']],
            )
            return obj

        def encode(self):
            json = {}
            json['sensors'] = [Interface.encode(x0) for x0 in self.sensors]
            json['slots'] = [Interface.encode(x0) for x0 in self.slots]
            return json

    # value object
    class InfoChangedEvent(raritan.rpc.idl.Event):
        idlType = "sensors.Logger_3_1_1.InfoChangedEvent:1.0.0"

        def __init__(self, oldInfo, newInfo, source):
            super(raritan.rpc.sensors.Logger.InfoChangedEvent, self).__init__(source)
            typecheck.is_struct(oldInfo, raritan.rpc.sensors.Logger.Info, AssertionError)
            typecheck.is_struct(newInfo, raritan.rpc.sensors.Logger.Info, AssertionError)

            self.oldInfo = oldInfo
            self.newInfo = newInfo

        def encode(self):
            json = super(raritan.rpc.sensors.Logger.InfoChangedEvent, self).encode()
            json['oldInfo'] = raritan.rpc.sensors.Logger.Info.encode(self.oldInfo)
            json['newInfo'] = raritan.rpc.sensors.Logger.Info.encode(self.newInfo)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldInfo = raritan.rpc.sensors.Logger.Info.decode(json['oldInfo'], agent),
                newInfo = raritan.rpc.sensors.Logger.Info.decode(json['newInfo'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldInfo", "newInfo"]
            elements = elements + super(raritan.rpc.sensors.Logger.InfoChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.Logger_3_1_1.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.Logger.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSettings, raritan.rpc.sensors.Logger.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.sensors.Logger.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.sensors.Logger.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.sensors.Logger.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.sensors.Logger.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.sensors.Logger.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.sensors.Logger.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.sensors.Logger.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class LoggedSensorsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.Logger_3_1_1.LoggedSensorsChangedEvent:1.0.0"

        def __init__(self, oldSensors, newSensors, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.Logger.LoggedSensorsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSensors, raritan.rpc.sensors.Logger.SensorSet, AssertionError)
            typecheck.is_struct(newSensors, raritan.rpc.sensors.Logger.SensorSet, AssertionError)

            self.oldSensors = oldSensors
            self.newSensors = newSensors

        def encode(self):
            json = super(raritan.rpc.sensors.Logger.LoggedSensorsChangedEvent, self).encode()
            json['oldSensors'] = raritan.rpc.sensors.Logger.SensorSet.encode(self.oldSensors)
            json['newSensors'] = raritan.rpc.sensors.Logger.SensorSet.encode(self.newSensors)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSensors = raritan.rpc.sensors.Logger.SensorSet.decode(json['oldSensors'], agent),
                newSensors = raritan.rpc.sensors.Logger.SensorSet.decode(json['newSensors'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSensors", "newSensors"]
            elements = elements + super(raritan.rpc.sensors.Logger.LoggedSensorsChangedEvent, self).listElements()
            return elements

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.Logger.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.Logger.Info, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.Logger.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.Logger.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.sensors.Logger.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.sensors.Logger.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    STATE_UNAVAILABLE = 0

    STATE_OPEN = 1

    STATE_CLOSE = 2

    STATE_BELOW_LOWER_CRITICAL = 3

    STATE_BELOW_LOWER_WARNING = 4

    STATE_NORMAL = 5

    STATE_ABOVE_UPPER_WARNING = 6

    STATE_ABOVE_UPPER_CRITICAL = 7

    STATE_ON = 8

    STATE_OFF = 9

    STATE_ALARMED = 10

    STATE_OK = 11

    STATE_MARGINAL = 12

    STATE_FAIL = 13

    STATE_YES = 14

    STATE_NO = 15

    STATE_STANDBY = 16

    STATE_ONE = 17

    STATE_TWO = 18

    STATE_IN_SYNC = 19

    STATE_OUT_OF_SYNC = 20

    STATE_FAULT = 21

    STATE_SELF_TEST = 22

    STATE_I1_OPEN_FAULT = 23

    STATE_I1_SHORT_FAULT = 24

    STATE_I2_OPEN_FAULT = 25

    STATE_I2_SHORT_FAULT = 26

    STATE_WARNING = 27

    STATE_CRITICAL = 28

    STATE_NON_REDUNDANT = 29

    class _getTimeStamps(Interface.Method):
        name = 'getTimeStamps'

        @staticmethod
        def encode(recid, count):
            typecheck.is_int(recid, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['recid'] = recid
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            timestamps = [raritan.rpc.Time.decode(x0) for x0 in rsp['timestamps']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in timestamps:
                typecheck.is_time(x0, DecodeException)
            return (_ret_, timestamps)

    # structure
    class Record(Structure):
        idlType = "sensors.Logger_3_1_1.Record:1.0.0"
        elements = ["available", "takenValidSamples", "state", "minValue", "avgValue", "maxValue"]

        def __init__(self, available, takenValidSamples, state, minValue, avgValue, maxValue):
            typecheck.is_bool(available, AssertionError)
            typecheck.is_int(takenValidSamples, AssertionError)
            typecheck.is_int(state, AssertionError)
            typecheck.is_double(minValue, AssertionError)
            typecheck.is_double(avgValue, AssertionError)
            typecheck.is_double(maxValue, AssertionError)

            self.available = available
            self.takenValidSamples = takenValidSamples
            self.state = state
            self.minValue = minValue
            self.avgValue = avgValue
            self.maxValue = maxValue

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                available = json['available'],
                takenValidSamples = json['takenValidSamples'],
                state = json['state'],
                minValue = json['minValue'],
                avgValue = json['avgValue'],
                maxValue = json['maxValue'],
            )
            return obj

        def encode(self):
            json = {}
            json['available'] = self.available
            json['takenValidSamples'] = self.takenValidSamples
            json['state'] = self.state
            json['minValue'] = self.minValue
            json['avgValue'] = self.avgValue
            json['maxValue'] = self.maxValue
            return json

    class _getSensorRecords(Interface.Method):
        name = 'getSensorRecords'

        @staticmethod
        def encode(sensor, recid, count):
            typecheck.is_interface(sensor, raritan.rpc.sensors.Sensor, AssertionError)
            typecheck.is_int(recid, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['sensor'] = Interface.encode(sensor)
            args['recid'] = recid
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            recs = [raritan.rpc.sensors.Logger.Record.decode(x0, agent) for x0 in rsp['recs']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in recs:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.Record, DecodeException)
            return (_ret_, recs)

    class _getPeripheralDeviceRecords(Interface.Method):
        name = 'getPeripheralDeviceRecords'

        @staticmethod
        def encode(slot, recid, count):
            typecheck.is_interface(slot, raritan.rpc.peripheral.DeviceSlot, AssertionError)
            typecheck.is_int(recid, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['slot'] = Interface.encode(slot)
            args['recid'] = recid
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            recs = [raritan.rpc.sensors.Logger.Record.decode(x0, agent) for x0 in rsp['recs']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in recs:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.Record, DecodeException)
            return (_ret_, recs)

    # structure
    class TimedRecord(Structure):
        idlType = "sensors.Logger_3_1_1.TimedRecord:1.0.0"
        elements = ["timestamp", "record"]

        def __init__(self, timestamp, record):
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_struct(record, raritan.rpc.sensors.Logger.Record, AssertionError)

            self.timestamp = timestamp
            self.record = record

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                record = raritan.rpc.sensors.Logger.Record.decode(json['record'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['record'] = raritan.rpc.sensors.Logger.Record.encode(self.record)
            return json

    class _getSensorTimedRecords(Interface.Method):
        name = 'getSensorTimedRecords'

        @staticmethod
        def encode(sensor, recid, count):
            typecheck.is_interface(sensor, raritan.rpc.sensors.Sensor, AssertionError)
            typecheck.is_int(recid, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['sensor'] = Interface.encode(sensor)
            args['recid'] = recid
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            recs = [raritan.rpc.sensors.Logger.TimedRecord.decode(x0, agent) for x0 in rsp['recs']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in recs:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.TimedRecord, DecodeException)
            return (_ret_, recs)

    class _getPeripheralDeviceTimedRecords(Interface.Method):
        name = 'getPeripheralDeviceTimedRecords'

        @staticmethod
        def encode(slot, recid, count):
            typecheck.is_interface(slot, raritan.rpc.peripheral.DeviceSlot, AssertionError)
            typecheck.is_int(recid, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['slot'] = Interface.encode(slot)
            args['recid'] = recid
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            recs = [raritan.rpc.sensors.Logger.TimedRecord.decode(x0, agent) for x0 in rsp['recs']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in recs:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.TimedRecord, DecodeException)
            return (_ret_, recs)

    class _getLoggedSensors(Interface.Method):
        name = 'getLoggedSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.sensors.Logger.SensorSet.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.sensors.Logger.SensorSet, DecodeException)
            return _ret_

    class _setLoggedSensors(Interface.Method):
        name = 'setLoggedSensors'

        @staticmethod
        def encode(sensors):
            typecheck.is_struct(sensors, raritan.rpc.sensors.Logger.SensorSet, AssertionError)
            args = {}
            args['sensors'] = raritan.rpc.sensors.Logger.SensorSet.encode(sensors)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _enableSensors(Interface.Method):
        name = 'enableSensors'

        @staticmethod
        def encode(sensors):
            typecheck.is_struct(sensors, raritan.rpc.sensors.Logger.SensorSet, AssertionError)
            args = {}
            args['sensors'] = raritan.rpc.sensors.Logger.SensorSet.encode(sensors)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _disableSensors(Interface.Method):
        name = 'disableSensors'

        @staticmethod
        def encode(sensors):
            typecheck.is_struct(sensors, raritan.rpc.sensors.Logger.SensorSet, AssertionError)
            args = {}
            args['sensors'] = raritan.rpc.sensors.Logger.SensorSet.encode(sensors)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _isSensorEnabled(Interface.Method):
        name = 'isSensorEnabled'

        @staticmethod
        def encode(sensor):
            typecheck.is_interface(sensor, raritan.rpc.sensors.Sensor, AssertionError)
            args = {}
            args['sensor'] = Interface.encode(sensor)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _isSlotEnabled(Interface.Method):
        name = 'isSlotEnabled'

        @staticmethod
        def encode(slot):
            typecheck.is_interface(slot, raritan.rpc.peripheral.DeviceSlot, AssertionError)
            args = {}
            args['slot'] = Interface.encode(slot)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _enableAllSensors(Interface.Method):
        name = 'enableAllSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _disableAllSensors(Interface.Method):
        name = 'disableAllSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getSensorSetTimestamp(Interface.Method):
        name = 'getSensorSetTimestamp'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.Time.decode(rsp['_ret_'])
            typecheck.is_time(_ret_, DecodeException)
            return _ret_

    # structure
    class LogRow(Structure):
        idlType = "sensors.Logger_3_1_1.LogRow:1.0.0"
        elements = ["sensorSetTimestamp", "timestamp", "sensorRecords", "peripheralDeviceRecords"]

        def __init__(self, sensorSetTimestamp, timestamp, sensorRecords, peripheralDeviceRecords):
            typecheck.is_time(sensorSetTimestamp, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            for x0 in sensorRecords:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.Record, AssertionError)
            for x0 in peripheralDeviceRecords:
                typecheck.is_struct(x0, raritan.rpc.sensors.Logger.Record, AssertionError)

            self.sensorSetTimestamp = sensorSetTimestamp
            self.timestamp = timestamp
            self.sensorRecords = sensorRecords
            self.peripheralDeviceRecords = peripheralDeviceRecords

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sensorSetTimestamp = raritan.rpc.Time.decode(json['sensorSetTimestamp']),
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                sensorRecords = [raritan.rpc.sensors.Logger.Record.decode(x0, agent) for x0 in json['sensorRecords']],
                peripheralDeviceRecords = [raritan.rpc.sensors.Logger.Record.decode(x0, agent) for x0 in json['peripheralDeviceRecords']],
            )
            return obj

        def encode(self):
            json = {}
            json['sensorSetTimestamp'] = raritan.rpc.Time.encode(self.sensorSetTimestamp)
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['sensorRecords'] = [raritan.rpc.sensors.Logger.Record.encode(x0) for x0 in self.sensorRecords]
            json['peripheralDeviceRecords'] = [raritan.rpc.sensors.Logger.Record.encode(x0) for x0 in self.peripheralDeviceRecords]
            return json

    class _getLogRow(Interface.Method):
        name = 'getLogRow'

        @staticmethod
        def encode(recid):
            typecheck.is_int(recid, AssertionError)
            args = {}
            args['recid'] = recid
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            row = raritan.rpc.sensors.Logger.LogRow.decode(rsp['row'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(row, raritan.rpc.sensors.Logger.LogRow, DecodeException)
            return (_ret_, row)
    def __init__(self, target, agent):
        super(Logger, self).__init__(target, agent)
        self.getInfo = Logger._getInfo(self)
        self.getSettings = Logger._getSettings(self)
        self.setSettings = Logger._setSettings(self)
        self.getTimeStamps = Logger._getTimeStamps(self)
        self.getSensorRecords = Logger._getSensorRecords(self)
        self.getPeripheralDeviceRecords = Logger._getPeripheralDeviceRecords(self)
        self.getSensorTimedRecords = Logger._getSensorTimedRecords(self)
        self.getPeripheralDeviceTimedRecords = Logger._getPeripheralDeviceTimedRecords(self)
        self.getLoggedSensors = Logger._getLoggedSensors(self)
        self.setLoggedSensors = Logger._setLoggedSensors(self)
        self.enableSensors = Logger._enableSensors(self)
        self.disableSensors = Logger._disableSensors(self)
        self.isSensorEnabled = Logger._isSensorEnabled(self)
        self.isSlotEnabled = Logger._isSlotEnabled(self)
        self.enableAllSensors = Logger._enableAllSensors(self)
        self.disableAllSensors = Logger._disableAllSensors(self)
        self.getSensorSetTimestamp = Logger._getSensorSetTimestamp(self)
        self.getLogRow = Logger._getLogRow(self)

#
# Section generated by IdlC from "Switch.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event


# interface
class Switch(StateSensor):
    idlType = "sensors.Switch:2.0.7"

    ERR_INVALID_PARAMETER = 1

    ERR_NOT_AVAILABLE = 2

    ERR_PDC_POWER_LIMIT = 3

    class _setState(Interface.Method):
        name = 'setState'

        @staticmethod
        def encode(newState):
            typecheck.is_int(newState, AssertionError)
            args = {}
            args['newState'] = newState
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # value object
    class SwitchEvent(raritan.rpc.event.UserEvent):
        idlType = "sensors.Switch_2_0_7.SwitchEvent:1.0.0"

        def __init__(self, targetState, actUserName, actIpAddr, source):
            super(raritan.rpc.sensors.Switch.SwitchEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(targetState, AssertionError)

            self.targetState = targetState

        def encode(self):
            json = super(raritan.rpc.sensors.Switch.SwitchEvent, self).encode()
            json['targetState'] = self.targetState
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                targetState = json['targetState'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["targetState"]
            elements = elements + super(raritan.rpc.sensors.Switch.SwitchEvent, self).listElements()
            return elements
    def __init__(self, target, agent):
        super(Switch, self).__init__(target, agent)
        self.setState = Switch._setState(self)
