#!/bin/sh
### BEGIN INIT INFO
# Provides:          rarpd
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: RARP lookup daemon
# Description:       Rarpd is a deamon allowing network devices
#                    to be assigned an IP address bases on their
#                    Ethernet MAC address alone. The service
#                    implements the RARP protocol standard.
### END INIT INFO

DESC="RARP lookup daemon"
NAME="rarpd"

DAEMON="/usr/sbin/rarpd"
SCRIPT="/etc/init.d/$NAME"

PATH=/sbin:/bin:/usr/sbin:/usr/bin

# Default options
OPTS="-e -v"

test -x $DAEMON || exit 0

# Read configuration file if it all present.
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

# Detect VERBOSE mode and load any rcS variables.
. /lib/init/vars.sh

# Define all LSB log_* functions.
. /lib/lsb/init-functions

case "$1" in
  start)
	log_daemon_msg "Starting $DESC" "$NAME"
	start-stop-daemon --start --quiet --exec $DAEMON -- $OPTS
	case "$?" in
		0) log_end_msg 0 ;;
		1) log_progress_msg "already up and running"
		   log_end_msg 0 ;;
		*) log_end_msg 1 ;;
	esac
	;;
  stop)
	log_daemon_msg "Stopping $DESC" "$NAME"
	start-stop-daemon --stop --quiet --exec $DAEMON
	case "$?" in
		0) log_end_msg 0 ;;
		1) log_progress_msg "not running"
		   log_end_msg 0 ;;
		*) log_end_msg 1 ;;
	esac
	;;
  restart|force-reload)
	log_action_msg "Restarting $DESC: $NAME"
	$0 stop
	sleep 1
	$0 start
	;;
  status)
	status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
	;;
  *)
	echo "Usage: $SCRIPT {start|stop|restart|force-reload|status}" >&2
	exit 3
	;;
esac

exit 0
