#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

void RCUI_move_up (GtkListStore *list_store,  GtkTreeIter *what)
{
  GtkTreePath *path;
  GtkTreeIter prev_iter;
    
  path = gtk_tree_model_get_path (GTK_TREE_MODEL(list_store), what);
  if (gtk_tree_path_prev (path)) {
    gtk_tree_model_get_iter (GTK_TREE_MODEL(list_store), &prev_iter, path);
    gtk_list_store_move_before (list_store, what, &prev_iter);
    
    RCUI_update_state_all (list_store);
  }
  gtk_tree_path_free(path);
}

void RCUI_move_down (GtkListStore *list_store, GtkTreeIter *what)
{
  GtkTreePath *path;
  GtkTreeIter prev_iter;

  path = gtk_tree_model_get_path (GTK_TREE_MODEL(list_store), what);
  gtk_tree_path_next (path);
  
  if (gtk_tree_model_get_iter (GTK_TREE_MODEL(list_store), &prev_iter, path) == TRUE) {
    gtk_list_store_move_after (list_store, what, &prev_iter);
    
    RCUI_update_state_all (list_store);
  }
  gtk_tree_path_free(path);
}

void RCUI_insert_after (GtkListStore *list_store, GtkTreeIter *where,
                      gchar *res_name, gchar *res_expr, gchar *res_value,
                      gchar *in_expr)
{
  /* Nota : here, expr has already been executed by engine */
  
  GtkTreeIter iter;

  gtk_list_store_insert_after (list_store, &iter, where);
  
  gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, res_name,
                    EXPR_COLUMN, res_expr,
                    VALUE_COLUMN, res_value,
                    RUN_COLUMN, TRUE,
		                INPUT_COLUMN, in_expr,
                    -1);
                    
  RCUI_update_state_all(list_store);
                  
}

void RCUI_insert_before (GtkListStore *list_store, GtkTreeIter *where,
                      gchar *res_name, gchar *res_expr, gchar *res_value,
                      gchar *in_expr)
{
  /* Nota : here, expr has already been executed by engine */
  
  GtkTreeIter iter;

  gtk_list_store_insert_before (list_store, &iter, where);
  
  gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, res_name,
                    EXPR_COLUMN, res_expr,
                    VALUE_COLUMN, res_value,
		                INPUT_COLUMN, in_expr,
                    RUN_COLUMN, TRUE,
                    -1);
                    
  RCUI_update_state_all (list_store);
                  
}

void RCUI_switch_activate (GtkListStore *list_store, GtkTreeIter *position)
{

  gboolean is_active;  
  gtk_tree_model_get (GTK_TREE_MODEL(list_store), position, RUN_COLUMN, &is_active, -1);      

  gtk_list_store_set (list_store, position,
                    RUN_COLUMN, !is_active,
                    -1);
  RCUI_update_state_all (list_store);               
}

GtkTreeIter RCUI_append_expr (GtkListStore *list_store, 
                      gchar *res_name, gchar *res_expr, gchar *res_value,
                      gchar *in_expr)
{
  /* Nota : here, expr has already been executed by engine */
  
  GtkTreeIter iter;

  gtk_list_store_append (list_store, &iter);
  
  gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, res_name,
                    EXPR_COLUMN, res_expr,
                    VALUE_COLUMN, res_value,
                    RUN_COLUMN, TRUE,
		                INPUT_COLUMN, in_expr,
                    -1);
                    
  RCUI_update_varw_lists();
  return iter;
}


void RCUI_remove_expr (GtkListStore *list_store, GtkTreeIter *piter)
{
  gchar *name;
  gchar *genexpr;
  gboolean valid;
  
  gtk_tree_model_get (GTK_TREE_MODEL(list_store), piter, NAME_COLUMN, &name, -1);
  valid = gtk_list_store_remove(list_store, piter);
  
  /* generate 'rm' command if it's a var/func */
  if (strlen(name) > 0) {
    genexpr = g_strdup_printf("rm %s", name);
    rc_engine_execute( RC_engine, genexpr );
    if (genexpr) g_free (genexpr);
  }
  
  if (name) g_free (name);
  
  if (valid) {
    RCUI_update_state_all (list_store);
  }
  
  else 
    /* last line has been removed */
    RCUI_update_varw_lists();
}                      

void RCUI_replace_expr (GtkListStore *list_store, GtkTreeIter *piter, 
                      gchar *name, gchar *expr, gchar *value, gchar *in_expr)
{  
  gchar *oldname;
  gchar *genexpr;
  
  gtk_tree_model_get (GTK_TREE_MODEL(list_store), piter, NAME_COLUMN, &oldname, -1);
  
  /* generate 'rm' command if it's a var/func */
  if (strlen(name) > 0) {
    genexpr = g_strdup_printf("rm %s", oldname);
    rc_engine_execute( RC_engine, genexpr );
    if (genexpr) g_free (genexpr);
  }
  
  if (oldname) g_free (oldname);
  
  gtk_list_store_set (list_store, piter,
                    NAME_COLUMN, name,
                    EXPR_COLUMN, expr,
                    VALUE_COLUMN, value,
                    RUN_COLUMN, TRUE,
		                INPUT_COLUMN, in_expr,
                    -1);
                   
   RCUI_update_state_all (list_store); 
   RCUI_update_varw_lists();              
}
