/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "logswidget.h"
#include <QMessageBox>
#include <QFile>
#include <QTextStream>
#include <QDebug>
#include <QScrollBar>
#include <QFileDialog>
#include <RdsClient>
#include <RdsFileManager>


LogsWidget::LogsWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::LogsWidget()
{
	setupUi(this);
	
	ReturnValue ret = rdsClient()->listLogs();
	if(ret.isError())
	{
		QMessageBox::warning(this,"Error", "Failed to get the list of logs: " + ret.errString());
		return;
	}
	
	QStringList logs = ret.toStringList();
	logs.sort();
	
	LogChooser->addItems(logs);
	LogText->setText("Select a log file to view.");
	
	SaveButton->setEnabled(false);
}

LogsWidget::~LogsWidget()
{
}

void LogsWidget::on_LogChooser_activated(QString filename)
{
	RdsFileManager mgr;
	ReturnValue ret = mgr.init();
	
	if(ret.isError())
	{
		QMessageBox::warning(this,"Error", "Failed to get the file manager: " + ret.errString());
		return;
	}
	
	ret = mgr.fileContents(filename);
	if(ret.isError())
	{
		QMessageBox::warning(this,"Error", "Failed to get the log file contents: " + ret.errString());
		return;
	}
	
	QString text;
	
	text = ret.toString();
	
	LogText->clear();
	LogText->setText(text);
	QTextCursor c = LogText->textCursor();
	c.movePosition(QTextCursor::End);
	LogText->setTextCursor(c);
	
	SaveButton->setEnabled(true);
}

void LogsWidget::on_ReloadButton_clicked()
{
	on_LogChooser_activated(LogChooser->currentText());
}

void LogsWidget::on_SaveButton_clicked()
{
	QFileInfo info(LogChooser->currentText());
	
	QString filename = QFileDialog::getSaveFileName(this, "Save log file", info.fileName());
	if(filename == "") return;
	
	QFile file(filename);
	if(!file.open(QFile::WriteOnly | QFile::Truncate))
	{
		QMessageBox::warning(this,"Error", "Failed to open file for writing.");
		return;
	}
	
	QString log = LogText->toPlainText();
	QTextStream source(&log);
	QTextStream stream(&file);
	
	QString line;
	while((line = source.readLine()) != QString::Null())
	{
		stream << line << endl;
	}
	
	file.close();
}
