/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
***************************************************************************/

#ifndef NETWORKSAVEDDIALOG_H
#define NETWORKSAVEDDIALOG_H

#include <QDialog>
#include "ui_networksavedialog.h"
#include <ReturnValue>
#include <RdsClient>
#include <rdsprovisionator.h>

class NetworkSaveDialog : public QDialog, private Ui::NetworkSaveDialog
{
	Q_OBJECT
public:
	NetworkSaveDialog(QWidget* parent = 0, Qt::WFlags fl = 0);
	~NetworkSaveDialog();

	ReturnValue setup(RdsProvisionator *p, QVariantMap settings);

protected slots:
	void onTimerUpdate();
	void timeout();
	void connected(uint id, ReturnValue ret);
	void doConnect();
	void onMinorProgress(const QString &msg);
	void onMajorProgress(const QString &msg);
	void onCompleted(const ReturnValue &ret);
	void on_ShowLogCheck_toggled(bool state);

private:
	RdsClient *_client;
	RdsProvisionator *_provisionator;
	QVariantMap _settings;
	QList<QPixmap> _loadingframes;
	int _loadingframe;
	QTimer *_timer;
	QTime _time;
	QString _user;
	QString _pass;
	QString _ip;
	QString _oldip;
	QString _service;
	int _port;
	bool _reverted;
};

#endif

