/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsentitysortmodel.h"
#include "rdsentitysortmodel_p.h"
#include <QStringList>
#include <QDebug>

RdsEntitySortModel::RdsEntitySortModel(RdsEntityModel *parent)
		: QSortFilterProxyModel(parent)
{
	setFilterCaseSensitivity(Qt::CaseInsensitive);
	setDynamicSortFilter(true);
	qxt_d().visibleidsenabled = false;
}


RdsEntitySortModel::~RdsEntitySortModel()
{
}

bool RdsEntitySortModel::filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const
{
	QModelIndex index = sourceModel()->index(sourceRow,0, sourceParent);
	RdsEntityModel::Cache *cache = (RdsEntityModel::Cache *)index.internalPointer();
	if(cache == NULL) return(false);
	
	if(qxt_d().visibleidsenabled)
	{
		bool found = false;
		
		foreach(QString id, qxt_d().visibleids)
		{
			if(cache->id().toLower() == id.toLower()) found = true;
		}
		
		if(!found) return(false);
	}
	
	foreach(QString id, qxt_d().hiddenids)
	{
		if(cache->id().toLower() == id.toLower()) return(false);
	}
	
	foreach(QRegExp regex, qxt_d().hiddenidsregex)
	{
		if(regex.exactMatch(cache->id())) return(false);
	}
	
	if(qxt_d().hiddentypes.contains(cache->type())) return(false);
	
	if (filterRegExp().pattern() == "")
	{
		return(true);
	}
	
	if(cache->children().count() > 0) return(true);
	
	QString data = sourceModel()->data(index).toString();
	QRegExp regex = filterRegExp();
	regex.setPatternSyntax(QRegExp::Wildcard);
	regex.setCaseSensitivity(Qt::CaseInsensitive);
	return(data.contains(regex));
}

bool RdsEntitySortModel::lessThan(const QModelIndex &left, const QModelIndex &right) const
{
	RdsEntityModel::Cache *leftcache = (RdsEntityModel::Cache *)left.internalPointer();
	RdsEntityModel::Cache *rightcache = (RdsEntityModel::Cache *)right.internalPointer();
	if((leftcache == NULL) || (rightcache == NULL)) return(false);
	
	int leftgroup = ((leftcache->children().size() > 0) || (leftcache->isGroup()));
	int rightgroup = ((rightcache->children().size() > 0) || (rightcache->isGroup()));
	
	if(leftgroup != rightgroup)
	{
		if (leftgroup && !rightgroup)
			return(qxt_d().ascending);
		else
			return(!qxt_d().ascending);
	}
	
	return(QSortFilterProxyModel::lessThan(left,right));
}

void RdsEntitySortModel::sort(int column, Qt::SortOrder order)
{
	qxt_d().ascending = (order == Qt::AscendingOrder);
	QSortFilterProxyModel::sort(column, order);
}

QStringList RdsEntitySortModel::hiddenEntities()
{
	return(qxt_d().hiddenids);
}

void RdsEntitySortModel::setHiddenEntities(QStringList ids)
{
	qxt_d().hiddenids = ids;
	setFilterRegExp(filterRegExp());
}

QStringList RdsEntitySortModel::hiddenEntitiesRegex()
{
	QStringList list;
	foreach(QRegExp regex, qxt_d().hiddenidsregex)
	{
		list << regex.pattern();
	}
	
	return(list);
}

void RdsEntitySortModel::setHiddenEntitiesRegex(QStringList ids)
{
	qxt_d().hiddenidsregex.clear();
	foreach(QString pattern, ids)
	{
		qxt_d().hiddenidsregex << QRegExp(pattern);
	}
	setFilterRegExp(filterRegExp());
}


QStringList RdsEntitySortModel::hiddenTypes()
{
	return(qxt_d().hiddentypes);
}

void RdsEntitySortModel::setHiddenTypes(QStringList types)
{
	qxt_d().hiddentypes = types;
	setFilterRegExp(filterRegExp());
}

QStringList RdsEntitySortModel::visibleIds()
{
	return(qxt_d().visibleids);
}

bool RdsEntitySortModel::visibleIdsEnabled()
{
	return(qxt_d().visibleidsenabled);
}

void RdsEntitySortModel::setVisibleIds(const QStringList& ids)
{
	qxt_d().visibleids = ids;
	setFilterRegExp(filterRegExp());
}

void RdsEntitySortModel::setVisibleIdsEnabled(bool enabled)
{
	qxt_d().visibleidsenabled = enabled;
	setFilterRegExp(filterRegExp());
}


bool RdsEntitySortModel::ascending() const
{
	return(qxt_d().ascending);
}

bool RdsEntitySortModel::hasChildren(const QModelIndex &parent) const
{
	return(sourceModel()->hasChildren(mapToSource(parent)));
}
