/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsstoragedevicesortmodel.h"
#include <QDebug>

RdsStorageDeviceSortModel::RdsStorageDeviceSortModel(RdsEntityModel *parent)
		: RdsEntitySortModel(parent)
{
	_showused = false;
}


RdsStorageDeviceSortModel::~RdsStorageDeviceSortModel()
{
}

bool RdsStorageDeviceSortModel::filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const
{
	QModelIndex index = sourceModel()->index(sourceRow,0, sourceParent);
	RdsEntityModel::Cache *cache = (RdsEntityModel::Cache *)index.internalPointer();
	if(cache == NULL) return(false);
	
	if(!_showused)
	{
		if(cache->metadata().contains("used"))
		{
			//qDebug() << cache->metadata()["used"];
			if(cache->metadata()["used"].toBool()) return(false);
		}
	}
	
	return(true);
}

void RdsStorageDeviceSortModel::setShowUsed(bool used)
{
	_showused = used;
	invalidateFilter();
}