/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef SELECTIONDIALOG_H
#define SELECTIONDIALOG_H

#include <QDialog>
#include "ui_SelectionDialog.h"
#include <RdsEntityModel>
#include "rdsusergroupcomputermodel.h"
#include "rdsusergroupcomputersortmodel.h"

class SelectionDialog : public QDialog, private Ui::SelectionDialog
{
	Q_OBJECT

public:
	enum SelectionType
	{
		User = 1 << 0,
  		Group = 1 << 1,
    		Computer = 1 << 2,
      		Special = 1 << 3,
	};
	Q_DECLARE_FLAGS(SelectionTypes, SelectionType);
	
	SelectionDialog(SelectionTypes type, QWidget* parent = 0, Qt::WFlags fl = 0);
	~SelectionDialog();

	void setAllowMultipleSelections(bool allow);
	QString selectedItem();
	QStringList selectedItems();
	void AddWidget(QWidget *w);
	
protected slots:
	virtual void accept();
	void outputsChanged(QStringList);
	void contextMenu(const QPoint & pos);
	void showSystemObjects(bool show);
	
private:
	SelectionTypes _type;
	RdsUserGroupComputerModel *_model;
	RdsUserGroupComputerSortModel *_sort;
	RdsEntityManager *_manager;
	QItemSelectionModel *_selection;
	QStringList _entities;
	QAction *_showsystemaction;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(SelectionDialog::SelectionTypes);

#endif

