/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef LOGMANAGER_P_H
#define LOGMANAGER_P_H

#include "logmanager.h"
#include <qxtpimpl.h>

class LogManagerPrivate : public QxtPrivate<LogManager>
{
public:
	LogManagerPrivate()
	{
	}
	QXT_DECLARE_PUBLIC(LogManager);

class LogStdOut : public LogDest
	{
	public:
		void writeLog(LogManager::LogPriority priority, QString section, QString text);
	};

class LogStdErr : public LogDest
	{
	public:
		void writeLog(LogManager::LogPriority priority, QString section, QString text);
	};

class LogFile : public LogDest
	{
	public:
		LogFile(QString file, bool append = true);
		void writeLog(LogManager::LogPriority priority, QString section, QString text);
	private:
		QString filename;
	};

class LogSyslog : public LogDest
	{
	public:
		LogSyslog(const char *name);
		~LogSyslog();
		void writeLog(LogManager::LogPriority priority, QString section, QString text);
	};

	class LogMap
	{
	public:
		LogMap() {}
		LogMap(QString s, LogManager::LogPriority p) : section(s), priority(p) {}
		bool operator==(const LogMap &other)
		{
			return((section == other.section) && (priority == other.priority));
		}
		QString section;
		LogManager::LogPriority priority;
	};

	QMap<QString, LogDest *> logs;
	QMap<QString, LogMap> maps;
	QMutex logmutex;
};

class LogWriterPrivate : public QxtPrivate<LogWriter>
{
public:
	LogWriterPrivate()
	{
	}
	QXT_DECLARE_PUBLIC(LogWriter);

	LogManager::LogPriority priority;
	QString section;
};

#endif
