/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDHCPSUBNET_H
#define RDSDHCPSUBNET_H

#include <RdsDhcpValues>
#include <QxtPimpl>
#include <QPair>
#include <QHostAddress>

class RdsDhcpSubnetPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsDhcpSubnet : public RdsDhcpValues
{
	friend class RdsDhcpValues;
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsDhcpSubnet);
	QTRPC_SERVICEPROXY_PIMPL(RdsDhcpSubnet);
public:
	typedef QPair<QHostAddress, QHostAddress> Range;
	typedef QList<Range> RangeList;
	RdsDhcpSubnet(const RdsDhcpSubnet &other);
	~RdsDhcpSubnet();
	RdsDhcpSubnet& operator=(const RdsDhcpSubnet &other);

public slots:
	/**
	 *        Gets the name of the subnet
	 * @return QString containing the name
	 */
	ReturnValue name() const;
	/**
	 *        Sets the name of the subnet
	 * @param name the name of the subnet
	 * @return true
	 */
	ReturnValue setName(const QString &name);
	/**
	 *        Gets the address of the subnet
	 * @return QHostAddress containing the address
	 */
	ReturnValue address() const;
	/**
	 *        Sets the address of the subnet
	 * @param addr the address of the subnet
	 * @return true
	 */
	ReturnValue setAddress(const QHostAddress &addr);
	/**
	 *        Gets the netmask of the subnet
	 * @return QHostAddress conaining the address of the subnet
	 */
	ReturnValue netmask() const;
	/**
	 *        Sets the netmask for the subnet
	 * @param addr the netmask
	 * @return true
	 */
	ReturnValue setNetmask(const QHostAddress &addr);
	/**
	 * 	  Gets a list of the ranges in the subnet
	 * @return QList<QPair <QHostAddress, QHostAddress> >
	 */
	ReturnValue ranges() const;
	/**
	 *        Sets the ranges for the subnet
	 * @param ranges the list of address ranges in the subnet
	 * @return true
	 */
	ReturnValue setRanges(const QVariant &ranges);
	ReturnValue setRanges(const RangeList &ranges);

protected:
	RdsDhcpSubnet();
	virtual void setData(void* data);

};

Q_DECLARE_METATYPE(RdsDhcpSubnet::Range);
Q_DECLARE_METATYPE(RdsDhcpSubnet::RangeList);
Q_DECLARE_METATYPE(QHostAddress);
QTRPC_REGISTER_METATYPE(RdsDhcpSubnet::Range);
QTRPC_REGISTER_METATYPE(RdsDhcpSubnet::RangeList);
QTRPC_REGISTER_METATYPE(QHostAddress);

#endif
