/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSMULTIJOB_P_H
#define RDSMULTIJOB_P_H

#include <QxtPimpl>
#include <QMutex>
#include "rdsmultijob.h"

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsMultiJobRunner : public QObject
{
	Q_OBJECT;
public:
	RdsMultiJobRunner(RdsMultiJob* parentJob);
	ReturnValue start(const QList<RdsJob*>& list);
	ReturnValue activateJob(RdsJob* job);
	ReturnValue stop();
	ReturnValue pause();
	ReturnValue resume();

public slots:
	void progressChangedSlot(int percent, const QString& progressText, const QString& progressDetails);
	void statusChangedSlot(RdsJob::Status status);
	void newLogMessages(const QList<RdsJob::LogEntry> &logs);
	void finishedSlot(const ReturnValue& ret);

signals:
	void progressChanged(int percent, const QString& progressText, const QString& progressDetails);
	void statusChanged(RdsJob::Status status);
	void newLogMsg(const QString& line);
	void finished(const ReturnValue& ret);

protected:
	int _totalJobs;
	QList<RdsJob*> _jobs;
	RdsJob* _currentJob;
	RdsMultiJob* _parentJob;
	bool _isPaused;
};

class RdsMultiJobPrivate : public QxtPrivate<RdsMultiJob>
{
public:
	RdsMultiJobPrivate()
			: mutex(QMutex::Recursive),
			jobRunner(0)
	{
	}

	QMutex mutex;
	QList<RdsJob*> jobList;
	RdsMultiJobRunner* jobRunner;
};

#endif

