/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDNSRECORD_P_H
#define RDSDNSRECORD_P_H

#include <QxtPimpl>
#include <QSharedDataPointer>

/**
	@author Chris Vickery <chris@resara.com>
 */
class RdsDnsRecordData : public QSharedData
{
public:
	RdsDnsRecordData()
			: type(RdsDnsZone::Invalid)
	{
	}
	RdsDnsZone::RecordType type;
	QString key;
	QString value;
	QStringList comments;
	QString origin;
	QString ttl;

	bool operator==(const RdsDnsRecordData& other) const
	{
		if (type != other.type)
			return false;
		if (key != other.key)
			return false;
		if (value != other.value)
			return false;
		if (origin != other.origin)
			return false;
		if (ttl != other.ttl)
			return false;
		if (comments != other.comments)
			return false;
		return true;
	}
};

class RdsDnsRecordPrivate : public QxtPrivate<RdsDnsRecord>
{
public:
	RdsDnsRecordPrivate()
			: data(new RdsDnsRecordData())
	{
	}
	QSharedDataPointer<RdsDnsRecordData> data;
	static void normalizeRecord(QString& key, QString& origin);
};

#endif


