/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITY_H
#define RDSENTITY_H

#include <QxtPimpl>
#include <QString>
#include <QList>
#include <QVariant>
#include <rdsglobal.h>

class RdsEntityPrivate;
class RdsEntity;

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsEntity& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsEntity& object);
/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_SHARED_EXPORT RdsEntity
{
	QXT_DECLARE_PRIVATE(RdsEntity);
        friend RDS_SHARED_EXPORT QDataStream& ::operator>> (QDataStream& d, RdsEntity& guid);
        friend RDS_SHARED_EXPORT QDataStream& ::operator<< (QDataStream& d, const RdsEntity& guid);
public:
	RdsEntity();
	RdsEntity(const RdsEntity &object);
	~RdsEntity();
	
	RdsEntity &operator =(const RdsEntity &object);
	
	QString name() const;
	void setName(QString name);
	QString id() const;
	void setId(QString name);
	QString type() const;
	void setType(QString type);
	bool visible() const;
	void setVisible(bool visible);
	QVariantMap &metadata();
	QList<RdsEntity> &children();
	QVariantMap metadata() const;
	QList<RdsEntity> children() const;
	QString parent() const;
	void setParent(QString parent);
	bool isGroup() const;
	void setGroup(bool isgroup);
	bool hasMore() const;
	void setHasMore(bool more);
};

Q_DECLARE_METATYPE(RdsEntity);

#endif
