/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdssambaconfigtester.h"

REGISTER_TEST(RdsSambaConfigTester);

RdsSambaConfigTester::RdsSambaConfigTester(QObject *parent)
		: QObject(parent)
{
}


RdsSambaConfigTester::~RdsSambaConfigTester()
{
}

void RdsSambaConfigTester::init()
{
	if (QFile::exists("/tmp/testconf.conf"))
		QFile::remove("/tmp/testconf.conf");
// 	config = RdsSambaConfigParser("/tmp/testconf.conf");
}
/*
void RdsSambaConfigTester::constructorsFileNameTest()
{
	ReturnValue ___ret; // Don't use this.
	RdsSambaConfigParser test = config, test2(config), test3;
	QVERIFY(test.fileName() == config.fileName());
	QVERIFY(test2.fileName() == config.fileName());
	QVERIFY(config.fileName().toString() == "/tmp/testconf.conf");
	TEST_FUNCTION(config.setFileName("/tmp/newtestconf.conf"));
	QVERIFY(config.fileName().toString() != "/tmp/testconf.conf");
	QVERIFY(config.fileName().toString() == "/tmp/newtestconf.conf");
}
*/
void RdsSambaConfigTester::toHashMapKeyWR()
{
	ReturnValue ___ret; // Don't use this.
	QMap<QString, QMap<QString, QString> > hash;
	QHash<QString, QHash<QString, QString> > realhash;
	for (int i = 0; i < 5; ++i) // use 1 section each with 5 keys, each testing 5 values
	{
		for (int j = 0; j < 5; ++j) //assign a bunch of values
		{
			hash["section"][QString("key%1").arg(i)] = QString("value%1").arg(j);
			realhash["section"][QString("key%1").arg(i)] = QString("value%1").arg(j);
			config.setValue("section", QString("key%1").arg(i), QString("value%1").arg(j));
			QCOMPARE(config.getValue("section", QString("key%1").arg(i)).toString(), QString("value%1").arg(j));
		}
	}
	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QCOMPARE(config.toMap(), hash);

	QVERIFY(config.getValue("section", "no").isNull());
	QVERIFY(config.getValue("doesntexist", "no").isNull());

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	config.disableKey("section", "key1");

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QVERIFY(config.getValue("section", "key1").isNull());
	QVERIFY(!config.keyExists("section", "key1").toBool());
	QVERIFY(config.keyExists("section", "key1", true).toBool());
	config.setValue("section", "key1", "value1");
	QCOMPARE(config.getValue("section", "key1").toString(), QString("value1"));
	config.disableKey("section", "key1");
	QVERIFY(config.getValue("section", "key1").isNull());
	QVERIFY(!config.keyExists("section", "key1").toBool());
	QVERIFY(config.keyExists("section", "key1", true).toBool());
	config.enableKey("section", "key1");
	QVERIFY(config.keyExists("section", "key1").toBool());
	QVERIFY(config.keyExists("section", "key1", true).toBool());
	QCOMPARE(config.getValue("section", "key1").toString(), QString("value1"));

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QCOMPARE(config.listSections().toStringList(), QStringList(hash.keys()));
	QCOMPARE(config.listKeys("section").toStringList(), QStringList(hash["section"].keys()));

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	config.disableSection("section");
	hash = QMap<QString, QMap<QString, QString> >();
	QCOMPARE(config.toMap(), hash);
	config.disableKey("section", "key1");
	QVERIFY(!config.keyExists("section", "key1").toBool());
	QVERIFY(config.keyExists("section", "key1", true).toBool());
	config.enableSection("section");

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QVERIFY(!config.keyExists("section", "key1").toBool());
	QVERIFY(config.keyExists("section", "key1", true).toBool());
	QVERIFY(config.sectionExists("section").toBool());
	config.renameSection("section", "newsection");

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QVERIFY(!config.sectionExists("section").toBool());
	QVERIFY(config.sectionExists("newsection").toBool());

	for (int i = 0; i < 5; ++i)
	{
		config.enableKey("newsection", "key" + QString::number(i));
	}
	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QVERIFY(config.keyExists("newsection", "key1").toBool());
	config.removeKey("newsection", "key1");
	QVERIFY(!config.keyExists("newsection", "key1").toBool());
	QVERIFY(!config.keyExists("newsection", "key1", true).toBool());
	QVERIFY(config.getValue("section", "no").isNull());
	QVERIFY(config.getValue("doesntexist", "no").isNull());

	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	config.removeSection("newsection");
	TEST_FUNCTION(config.save());
	TEST_FUNCTION(config.reload());
	TEST_FUNCTION(config.reload());
	QVERIFY(!config.sectionExists("newsection").toBool());
}

void RdsSambaConfigTester::rdsKeyWR()
{
	QMap<QString, QMap<QString, QString> > rdshash;

	for (int i = 0; i < 5; ++i) // use 1 section each with 5 keys, each testing 5 values
	{
		for (int j = 0; j < 5; ++j) //assign a bunch of values
		{
			rdshash["section"][QString("key%1").arg(i)] = QString("value%1").arg(j);
			config.setRdsValue("section", QString("key%1").arg(i), QString("value%1").arg(j));
			QCOMPARE(config.getRdsValue("section", QString("key%1").arg(i)).toString(), QString("value%1").arg(j));
		}
	}

	QCOMPARE(config.listRdsKeys("section").toStringList(), QStringList(rdshash["section"].keys()));

	config.disableRdsKey("section", "key1");
	QVERIFY(config.getRdsValue("section", "key1").isNull());
	QVERIFY(!config.rdsKeyExists("section", "key1").toBool());
	QVERIFY(config.rdsKeyExists("section", "key1", true).toBool());

	config.setRdsValue("section", "key1", "value1");
	QCOMPARE(config.getRdsValue("section", "key1").toString(), QString("value1"));
	config.disableRdsKey("section", "key1");
	QVERIFY(config.getRdsValue("section", "key1").isNull());
	config.enableRdsKey("section", "key1");
	QCOMPARE(config.getRdsValue("section", "key1").toString(), QString("value1"));

	QVERIFY(config.sectionExists("section").toBool());
	QVERIFY(config.sectionExists("section", true).toBool());

	config.disableSection("section");
	QVERIFY(!config.sectionExists("section").toBool());
	QVERIFY(config.sectionExists("section", true).toBool());
	QVERIFY(config.getRdsValue("section", "key1").isNull());
	QVERIFY(!config.rdsKeyExists("section", "key1").toBool());
	QVERIFY(config.rdsKeyExists("section", "key1", true).toBool());

	config.disableRdsKey("section", "key1");
	QVERIFY(!config.rdsKeyExists("section", "key1").toBool());
	QVERIFY(config.rdsKeyExists("section", "key1", true).toBool());

	config.enableSection("section");
	QVERIFY(!config.rdsKeyExists("section", "key1").toBool());
	QVERIFY(config.rdsKeyExists("section", "key1", true).toBool());

	QVERIFY(config.sectionExists("section").toBool());
	config.renameSection("section", "newsection");
	QVERIFY(!config.sectionExists("section").toBool());
	QVERIFY(!config.sectionExists("section", true).toBool());
	QVERIFY(config.sectionExists("newsection").toBool());
	QVERIFY(config.sectionExists("newsection", true).toBool());

	for (int i = 0; i < 5; ++i)
	{
		config.enableRdsKey("newsection", "key" + QString::number(i));
	}
	QVERIFY(config.rdsKeyExists("newsection", "key1").toBool());
	config.removeRdsKey("newsection", "key1");
	QVERIFY(!config.rdsKeyExists("newsection", "key1").toBool());
	QVERIFY(!config.rdsKeyExists("newsection", "key1", true).toBool());

	config.removeSection("newsection");
	QVERIFY(!config.sectionExists("newsection").toBool());
	QVERIFY(!config.sectionExists("newsection", true).toBool());
}
