/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsntacltester.h"

REGISTER_TEST(RdsNtAclTester);

#define ACL_PATH "/tmp/testdir/acl"
#define SEC_DESC "O:BAG:BAD:PAI(OA;OIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;S-1-5-21-2336184427-3484212696-2663171178-498)(OA;;CR;1131f6ad-9c07-11d1-f79f-00c04fc2dcd2;;S-1-5-21-2336184427-3484212696-2663171178-516)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967a86-0de6-11d0-a285-00aa003049e2;ED)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967a9c-0de6-11d0-a285-00aa003049e2;ED)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967aba-0de6-11d0-a285-00aa003049e2;ED)(OA;;CR;89e95b76-444d-4c62-991a-0facbeda640c;;BA)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ad-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ae-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;e2a36dc9-ae17-47c3-b58b-be34c55ba633;;S-1-5-32-557)(OA;;RP;c7407360-20bf-11d0-a768-00aa006e0529;;RU)(OA;;RP;b8119fd0-04f6-4762-ab7a-4986c76b3f9a;;RU)(OA;OIIO;RCRPLCLO;;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RCRPLCLO;;bf967a9c-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RCRPLCLO;;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;;CR;05c74c5e-4deb-43b4-bd9f-86664c2a7fd5;;AU)(OA;;CR;89e95b76-444d-4c62-991a-0facbeda640c;;ED)(OA;;CR;ccc2dc7d-a6ad-4a7a-8846-c04e3cc53501;;AU)(OA;;CR;280f369c-67c7-438e-ae98-1d46f3c6f541;;AU)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ae-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RP;b8119fd0-04f6-4762-ab7a-4986c76b3f9a;;AU)(OA;OIIO;RPWPCR;91e647de-d96f-4b70-9557-d63ff4f3ccd8;;PS)(A;;RCWDWORPWPCCLCSWLOCR;;;S-1-5-21-2336184427-3484212696-2663171178-512)(A;OI;RCSDWDWORPWPCCDCLCSWLODTCR;;;S-1-5-21-2336184427-3484212696-2663171178-519)(A;;RCRP;;;RU)(A;OI;LC;;;RU)(A;OI;RCSDWDWORPWPCCLCSWLOCR;;;BA)(A;;RP;;;WD)(A;;RCRPLCLO;;;ED)(A;;RCRPLCLO;;;AU)(A;;RCSDWDWORPWPCCDCLCSWLODTCR;;;SY)S:(OU;OIFA;WP;f30e3bbe-9ff0-11d1-b603-0000f80367c1;bf967aa5-0de6-11d0-a285-00aa003049e2;WD)(OU;OIFA;WP;f30e3bbf-9ff0-11d1-b603-0000f80367c1;bf967aa5-0de6-11d0-a285-00aa003049e2;WD)(AU;FA;CR;;;S-1-5-21-2336184427-3484212696-2663171178-513)(AU;FA;CR;;;BA)(AU;FA;WDWOWP;;;WD)"


RdsNtAclTester::RdsNtAclTester(QObject *parent)
		: QObject(parent)
{
}


RdsNtAclTester::~RdsNtAclTester()
{
}

void RdsNtAclTester::constructorTest()
{
	RdsNtAcl acl(SEC_DESC);
	RdsNtAcl acl1(acl), acl2(acl.toBinary()), acl3(acl.toString());
	QCOMPARE(acl1, acl);
	QCOMPARE(acl2, acl);
	QCOMPARE(acl3, acl);

	TEST_FUNCTION(acl.save(ACL_PATH));
	TEST_FUNCTION_ERROR(acl.save("/tmp/testdir/broked"));
	
	acl = RdsNtAcl::fromFile(ACL_PATH).value<RdsNtAcl>();
	QCOMPARE(acl, acl1);

	QCOMPARE(RdsNtAcl::getNtAclString(ACL_PATH), acl.toString());

	RdsNtAcl testacl1(acl), testacl2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream <<testacl1;
	}
	{
		QDataStream stream(ar);
		stream >>testacl2;
	}
	QCOMPARE(testacl2,testacl1);
}
