/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsjob.h"
#include "rdsjob_p.h"
#include <RdsClient>

QTRPC_CLIENTPROXY_PIMPL_IMPLEMENT(RdsJob);

RdsJob::RdsJob(QObject *parent)
		: ClientProxy(parent)
{
	QXT_INIT_PRIVATE(RdsJob);
}

RdsJob::RdsJob(const RdsJob &other)
		: ClientProxy(other)
{
	QXT_INIT_PRIVATE(RdsJob);
}


RdsJob::~RdsJob()
{
}

RdsJob &RdsJob::operator=(const RdsJob & other)
{
	ClientProxy::operator=(other);
	return *this;
}

QDataStream& operator<<(QDataStream& d, const RdsJob::LogEntry& log)
{
	d << log.log;
	d << log.level;
	d << log.timestamp;
	return d;
}

QDataStream& operator>>(QDataStream& d, RdsJob::LogEntry& log)
{
	d >> log.log;
	d >> log.level;
	d >> log.timestamp;
	return d;
}

QDataStream& operator<<(QDataStream& d, const RdsJob::LogLevel& log)
{
	d << static_cast<int>(log);
	return d;
}

QDataStream& operator>>(QDataStream& d, RdsJob::LogLevel& log)
{
	int level;
	d >> level;
	log = static_cast<RdsJob::LogLevel>(level);
	return d;
}

QDataStream& operator<<(QDataStream& d, const RdsJob::Status& log)
{
	d << static_cast<int>(log);
	return d;
}

QDataStream& operator>>(QDataStream& d, RdsJob::Status& log)
{
	int status;
	d >> status;
	log = static_cast<RdsJob::Status>(status);
	return d;
}
