/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsstoragedevicemanager.h"
#include "rdsstoragedevicemanager_p.h"
#include <RdsClient>

QTRPC_CLIENTPROXY_PIMPL_IMPLEMENT(RdsStorageDeviceManager);

RdsStorageDeviceManager::RdsStorageDeviceManager(QObject *parent)
		: RdsEntityManager(parent)
{
}

RdsStorageDeviceManager::RdsStorageDeviceManager(const RdsStorageDeviceManager &other)
		: RdsEntityManager(other)
{

}

RdsStorageDeviceManager::~RdsStorageDeviceManager()
{
}

RdsStorageDeviceManager &RdsStorageDeviceManager::operator=(const RdsStorageDeviceManager & other)
{
	RdsEntityManager::operator=(other);
	return *this;
}

ReturnValue RdsStorageDeviceManager::init()
{
	ReturnValue ret = rdsClient()->getService("StorageDeviceManager");
	if(ret.isError()) return(ret);
	
	*this = ret;
	return(true);
}

