/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef ACLMODEL_H
#define ACLMODEL_H

#include <QAbstractListModel>
#include <RdsNtAcl>
#include <RdsSid>
#include <QPixmap>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class AclModel : public QAbstractListModel
{
	Q_OBJECT
public:
	enum Type
	{
		Unknown,
  		User,
    		Group
	};
	
	struct Acl
	{
		RdsAce primaryace;
		QString name;
		bool inherited;
		bool allow;
		Type type;
		RdsSid sid;
		RdsAce::Flags flags;
		
		bool operator==(const Acl &other) const;
	};
	
	AclModel(QObject *parent = 0);
	~AclModel();

	void setAcl(RdsNtAcl *acl);
	void setAdvanced(bool advanced);
	int rowCount(const QModelIndex &parent = QModelIndex()) const;
	int columnCount(const QModelIndex &parent = QModelIndex()) const;
	QVariant data(const QModelIndex &index, int role) const;
	QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
	void reload();
	Acl getAclFromIndex(const QModelIndex &index) const;
	void removeAcl(const Acl &acl);
	void addAcl(const Acl &acl);
	
protected:
	void resolveAce(RdsAce &ace, Acl &acl);
	
private:	
	RdsNtAcl *_acl;
	bool _advanced;
	QList<Acl> _acls;
	QPixmap _usericon;
	QPixmap _groupicon;
	QPixmap _unknownicon;
};

#endif
