/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef CHECKWIDGET_H
#define CHECKWIDGET_H

#include <QWidget>
#include "ui_checkwidget.h"

class CheckWidget : public QWidget, private Ui::CheckWidget
{
	Q_OBJECT
public:
	Q_PROPERTY(QStringList checked READ checked WRITE setChecked);
	Q_PROPERTY(QStringList list READ list WRITE setList);
	
	CheckWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~CheckWidget();

	QStringList list() const;
	void setList(const QStringList &newlist);
	QStringList checked() const;
	void setChecked(const QStringList &newchecked);
	
signals:
	void changed();
	

};

#endif

