/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef PROVISIONWIZARD_H
#define PROVISIONWIZARD_H

#include <QDialog>
#include "ui_provisionwizard.h"
#include "rdsprovisionator.h"
#include <QVariantMap>
#include <QDateTime>

class ProvisionWizard : public QDialog, private Ui::ProvisionWizard
{
	Q_OBJECT
public:
	enum Page
	{
		Welcome,
		Network,
		NetworkConfig,
  		DateTime,
		Domain,
		Password,
		Dhcp,
		Provisioning,
		Finished
	};

	ProvisionWizard(QString user, QString pass, QString ip, int port, QString service, QWidget* parent = 0, Qt::WFlags fl = 0);
	~ProvisionWizard();

protected:
	void setupButtons(QString cancel, QString previous, QString next, bool ce, bool pe, bool ne);
	void setupHeader(QString main, QString desc);
	void showBox(bool show=false);
	void nextPage(Page page);
	void cancel(Page page);
	void previousPage(Page page);
	bool isValid(Page page);
	bool validTest(QLineEdit *edit, QString error);
	bool validTest(QLineEdit *edit, QString error, QRegExpValidator *validator);
	void getDefaultSettings();
	
protected slots:
	void pageChanged(int page);
	void on_CancelButton_clicked();
	void on_PreviousButton_clicked();
	void on_NextButton_clicked();
	void timeout();
	void connected(uint id, ReturnValue ret);
	void doConnect();
	void on_DomainNameEdit_textEdited(QString text);
	void on_RealmEdit_textEdited(QString text);
	void on_Password1Edit_textEdited(QString text);
	void on_Password2Edit_textEdited(QString text);
	void onMinorProgress(const QString &msg);
	void onMajorProgress(const QString &msg);
	void onCompleted(const ReturnValue &ret);
	void onTimerUpdate();
	void onDateTimeTimer();
	void on_DateEdit_dateChanged(QDate date);
	void on_TimeEdit_timeChanged(QTime time);
	
private:
	RdsProvisionator *_provisionator;
	QVariantMap _settings;
	QVariantMap _defaultsettings;
	QTimer *_timer;
	QTime _time;
	QString _user;
	QString _pass;
	QString _ip;
	QString _oldip;
	QString _service;
	int _port;
	bool _reverted;
	QString _lasttext;
	QList<QPixmap> _loadingframes;
	int _loadingframe;
	QDateTime _datetime;
};

#endif

