/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSPROVISIONATOR_H
#define RDSPROVISIONATOR_H

#include <ClientProxy>
#include <QTimer>
#include <QTime>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsProvisionator : public QtRpc::ClientProxy
{
	Q_OBJECT
	QTRPC_CLIENTPROXY(RdsProvisionator);
public:
	RdsProvisionator(QObject *parent = 0);
	~RdsProvisionator();

public slots:
	
signals:
	ReturnValue networkWorked();
	ReturnValue provision(const QVariantMap &map);
	ReturnValue applyNetworkSettings(const QVariantMap &map);
	ReturnValue getDefaultSettings() const;
	ReturnValue getDefaultSettings(QObject *object, const char *slot) const;
	ReturnValue setNetworkSettings(const QVariantMap &settings, bool updatehosts = false);
	ReturnValue setNetworkSettings(QObject *obj, const char *slot, const QVariantMap &settings, bool updatehosts = false);
	ReturnValue provisionDhcp(const QVariantMap &settings);
	ReturnValue installFinished(QObject *obj, const char *slot);
	QtRpc::Event minorProgress(const QString &str);
	QtRpc::Event majorProgress(const QString &str);
	QtRpc::Event completed(const ReturnValue &ret);
};

#endif
