/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsstoragesortmodel.h"
#include <QDebug>

RdsStorageSortModel::RdsStorageSortModel(RdsEntityModel *parent)
		: RdsEntitySortModel(parent)
{
}


RdsStorageSortModel::~RdsStorageSortModel()
{
}

bool RdsStorageSortModel::lessThan(const QModelIndex &left, const QModelIndex &right) const
{
	///TODO fix sorting weirdness
	RdsEntityModel::Cache *leftcache = (RdsEntityModel::Cache *)left.internalPointer();
	RdsEntityModel::Cache *rightcache = (RdsEntityModel::Cache *)right.internalPointer();
	if ((leftcache == NULL) || (rightcache == NULL)) return(false);

	QString lefttype;
	QString righttype;

	//if ((leftcache->children().size() > 0) || (leftcache->isGroup())) lefttype = "__GROUP__";
	lefttype = getType(leftcache);
	//if ((rightcache->children().size() > 0) || (rightcache->isGroup())) righttype = "__GROUP__";
	righttype = getType(rightcache);

	//qDebug() << lefttype << righttype;
	
	//if the two items are the same type, use the standard comparison function
	if (lefttype == righttype) return(QSortFilterProxyModel::lessThan(left, right));

	int leftlevel = getLevel(lefttype);
	int rightlevel = getLevel(righttype);

	//If we don't know the type of either item, just use the normal sort method
	if ((leftlevel < 0) || (rightlevel < 0)) return(QSortFilterProxyModel::lessThan(left, right));

	if (leftlevel < rightlevel)
		return(ascending());
	else
		return(!ascending());
}

int RdsStorageSortModel::getLevel(QString type) const
{
	//qDebug() << "TYPE:" << type;
	if (type == "mounted") return(1);
	if (type == "umounted") return(2);
	if (type == "disconnected") return(3);
	else return(-1);
}

QString RdsStorageSortModel::getType(RdsEntityModel::Cache *cache) const
{
	if(cache->metadata().contains("state") && (cache->metadata()["state"].toString().toLower() == "disconnected"))
		return("disconnected");
	
	if(cache->metadata().contains("mounted") && cache->metadata()["mounted"].toBool())
		return("mounted");
	else
		return("unmounted");
}
