/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsusergroupcomputermodel.h"
#include <QPixmap>
#include <QDebug>
#include <RdsUser>
#include <RdsGroup>
#include <RdsComputer>
#include <RdsOrganizationalUnit>
#include <QMessageBox>
#include "config.h"

RdsUserGroupComputerModel::RdsUserGroupComputerModel(RdsEntityManager *manager, QObject *parent)
		: RdsEntityModel(manager, 2, parent)
{
}


RdsUserGroupComputerModel::~RdsUserGroupComputerModel()
{
}


QVariant RdsUserGroupComputerModel::userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const
{
	Q_UNUSED(index);

	if ((role == Qt::DecorationRole) && (index.column() == 0))
	{
		if (cache->type() == "ou")
			return(QPixmap(findRdsIcon("./icons/16x16/folder.png")));
		else if (cache->type() == "user")
			return(QPixmap(findRdsIcon("./icons/16x16/userconfig.png")));
		else if (cache->type() == "group")
			return(QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16));
		else if (cache->type() == "computer")
			return(QPixmap(findRdsIcon("./icons/16x16/system.png")));
		else if (cache->type() == "special")
			return(QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16));
	}
	else if((role == Qt::DisplayRole) && (index.column() == 1))
	{
		return(cache->metadata().value("description"));
	}

	return(QVariant());
}

QVariant RdsUserGroupComputerModel::userHeaderData(int section, int role) const
{
	Q_UNUSED(section);
	if (role == Qt::DisplayRole)
	{
		switch (section)
		{
			case 0:
				return("Name");
			case 1:
				return("Description");
		      }
	      }

	      return(QVariant());
}

Qt::ItemFlags RdsUserGroupComputerModel::flags(const QModelIndex &index, Cache *cache) const
{
	Q_UNUSED(index);
	Q_UNUSED(cache);
	if(index.column() == 0) return(Qt::ItemIsEditable);
	else return(0);
}

bool RdsUserGroupComputerModel::setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache)
{
	Q_UNUSED(index);
	Q_UNUSED(role);
	if (cache->name() == value.toString()) return(false); //if the new name is the same, we didn't change anything
	if (value.toString() == "") return(false);

	ReturnValue ret;
	QString type;

	if (cache->type() == "ou")
	{
		if (!value.toString().contains(QRegExp("^[0-9a-zA-Z][^+\\;,=]*$")))
		{
			QMessageBox::critical(NULL, "Error", "The name must not contain any of these characters (+ \\ ; , =).");
			return(false);
		}
		type = "OU";
		RdsOrganizationalUnit ou(cache->id());
		ret = ou.setOu(value.toString());
	}
	else if (cache->type() == "user")
	{
		if (!value.toString().contains(QRegExp("^[0-9a-zA-Z][^+\\;,=]*$")))
		{
			QMessageBox::critical(NULL, "Error", "The name must not contain any of these characters (+ \\ ; , =).");
			return(false);
		}
		type = "user";
		RdsUser user(cache->id());
		ret = user.setCn(value.toString());
	}
	else if (cache->type() == "group")
	{
		if (!value.toString().contains(QRegExp("^[0-9a-zA-Z][^+\\;,=]*$")))
		{
			QMessageBox::critical(NULL, "Error", "The name must not contain any of these characters (+ \\ ; , =).");
			return(false);
		}
		type = "group";
		RdsGroup group(cache->id());
		ret = group.setCn(value.toString());
	}
	else if (cache->type() == "computer")
	{
		if (!value.toString().contains(QRegExp("^[0-9a-zA-Z][^+\\;,=]*$")))
		{
			QMessageBox::critical(NULL, "Error", "The name must not contain any of these characters (+ \\ ; , =).");
			return(false);
		}
		type = "computer";
		RdsComputer computer(cache->id());
		ret = computer.setCn(value.toString());
	}
	else
	{
		return(false);
	}

	if (ret.isError())
	{
		QMessageBox::critical(NULL, "Error:", "Failed to rename " + type + ": " + ret.errString());
		return(false);
	}

	QString newdn = ret.toString();
	//qDebug() << "New DN:" << newdn;

	manager()->renameEntity(cache->id(), newdn);

	return(true);
}

void RdsUserGroupComputerModel::move(Cache *entity, Cache *parent)
{
	Cache *dest = parent;

	if ((parent->type() != "ou") && (parent->type() != "root")) dest = parent->parent();
	if (dest == NULL) return;

	if (dest == entity->parent()) return; //We didn't actually move it, so don't bother

	QString destdn = dest->id();
	if ((destdn == "root") && (entity->type() == "user")) destdn = RdsOrganizationalUnit().userDn();
	else if ((destdn == "root") && (entity->type() == "group")) destdn = RdsOrganizationalUnit().groupDn();
	else if ((destdn == "root") && (entity->type() == "computer")) destdn = RdsOrganizationalUnit().computerDn();
	else if (destdn == "root") destdn = RdsOrganizationalUnit().dn();
	//qDebug() << "Moving:" << entity->id() << "To:" << destdn;

	RdsLdapObject o(entity->id());
	ReturnValue ret = o.move(destdn);
	if (ret.isError())
	{
		QMessageBox::critical(NULL, "Error:", "Failed to move user: " + ret.errString());
		return;
	}

	manager()->removeEntity(entity->id());
	manager()->addEntity(ret.toString());
}
