/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "unuseddevicedialog.h"
#include <QMessageBox>
#include "initializevolumedialog.h"

UnusedDeviceDialog::UnusedDeviceDialog(QWidget* parent, Qt::WFlags fl)
		: QDialog(parent, fl), Ui::UnusedDeviceDialog()
{
	setupUi(this);
	_manager = new RdsStorageDeviceManager(this);
	ReturnValue ret = _manager->init();
	if (ret.isError())
	{
		QMessageBox::critical(this, "Failed to get storage manager", ret.errString());
		return;
	}
	
	_model = new RdsStorageDeviceModel(_manager, this);
	_sort = new RdsStorageDeviceSortModel(_model);
	_sort->setSourceModel(_model);
	View->setModel(_sort);
	View->sortByColumn(0, Qt::AscendingOrder);
	_selection = View->selectionModel();
	_model->setupSelection(_sort, View);

	QObject::connect(_model, SIGNAL(inputChanged(QString, QString)), this, SLOT(inputChanged(QString, QString)));
}

UnusedDeviceDialog::~UnusedDeviceDialog()
{
}

void UnusedDeviceDialog::accept()
{
	if(_model->input() == 0)
	{
		QMessageBox::critical(this,"Error", "You must select a device to use.");
		return;
	}
	
	InitializeVolumeDialog dialog(this);
	ReturnValue ret = dialog.initializeStorageDevice(_manager, _model->input());
	if(ret.isError())
	{
		QMessageBox::critical(this,"Error","Failed to initialize volume: " + ret.errString());
		return;
	}
	
	if(!ret.toBool())
	{
		QDialog::accept();
		return;
	}
	
	dialog.exec();
	ret = dialog.result();
	
	if(ret.isError())
	{
		QMessageBox::critical(this,"Error","Failed to initialize volume: " + ret.errString());
		return;
	}
	
	QDialog::accept();
}

void UnusedDeviceDialog::on_ShowUsed_toggled(bool show)
{
	_sort->setShowUsed(show);
}
